<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Arr;
use App\Jobs\ProccessParatyComparation;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Log;
use Inertia\Inertia;
use App\Models\ParatyResult;
use App\Models\Site;
use App\Models\Agency;
use App\Models\Membership;
use App\Models\RoomsCategory;
use App\Models\Category;
use Carbon\Carbon;
use DB;
use Http;
use App\Models\MembershiMaster;

class ProccessParatyController extends Controller
{
    //
    public $paratyResult;

    public $sites;

    public $agency;

    public $timestamp;

    public $authHeader;

    public $url;

    public function __construct(ParatyResult $paratyResult, Site $sites, Agency $agency) 
    {
        $this->paratyResult = $paratyResult;

        $this->sites = $sites;

        $this->agency = $agency;

        $this->timestamp = time();
       
        $this->authHeader = 'ROIBACK APIKey=' .  config('roiback.api_roiback_key') . ',Signature=' . hash("sha512", config('roiback.api_roiback_key').config('roiback.api_roiback_secret_key').$this->timestamp) . ',timestamp=' . time();
       
        $this->url = 'https://api.roiback.com/v0/availability/by-hotels?codes=';
    }

    public function dashboard(Request $request)
    {   
        // dd($request);

        $membershipsMaster = MembershiMaster::all();

        $memberships = Membership::with(['sites', 'membershipCategory'])->orderBy('order', 'ASC')->get();
   
        $resortSearched = Site::where('id', ($request->resorts))->first(); 
        // Busqueda de los datos.

        $response  = $resortSearched ? $this->getRoibackRates($resortSearched, $request) : [];

        $results = Membership::where('id', ($request->membership))->with([
            'rooms' => function($query) use ($request, $resortSearched) {
                $query->with([
                    'agencyRooms' => function($agencyRooms) use ($request, $resortSearched)  {
                            // Aquí cargamos la agencia y la tabla de paraty_results para extraer toda la información de paraty.
                            $agencyRooms->with([
                                'information' => function($information) use ($request, $resortSearched)  {
                                    $information->when($request->date, function($dates, $date) {
                                        $dates->where('date_from', '>=', Carbon::parse($date[0])->format('Y-m-d'))->where('date_to', '<=', Carbon::parse($date[1])->format('Y-m-d'));
                                    }, function($dates) {
                                        $dates->where('date_from', '>=', Carbon::now()->format('Y-m-d'))
                                        ->where('date_from', '<=', Carbon::now()->addDays(6)->format('Y-m-d'));
                                    })
                                    ->when($request->currency, function($currencies, $currency) {
                                        $currencies->where('currency_code', $currency);
                                    }, function($currencies) {
                                        $currencies->where('currency_code', 'USD');
                                    })
                                    ->where('id_board', 2)
                                    ->where('nights', 1)
                                    ->when(($resortSearched->site_id ?? null), function($searchedSite, $resortSearched) {
                                        $searchedSite->where('id_hotel', $resortSearched);
                                    })
                                    ->orderBy('price', 'desc')->limit(1);
                                },
                                'agency' => function($agency) {
                                    $agency->select('id', 'agency_id', 'name', 'max_or_min', 'default_site');
                            }])
                            ->where('lang', $request->currency == 'MXN' ? 'es' : 'en');
                        }
                ])
                ->when($request->room, function($room, $search) {
                    $room->where('id', $search);
                })->when($resortSearched, function($filterByResort, $resortSearched) {
                    $filterByResort->where('site_id', $resortSearched->id);
                })
                ->when($request->category, function($filter, $category) use ($request) {
                    $filter->whereIn('rooms_category_id', $request->category);
                });
            }
        ])->get();
        
        $datesSearch = [];
        $resorts = $this->sites->with(['rooms'])->get();

        $data = [];
        foreach($results as $result):
            foreach($result->rooms as $roomKey => $room):
                foreach($room->agencyRooms as $agencyrooms):

                    $data[$room->id]['data'][$agencyrooms->agency_id] = [
                            'agency' => $agencyrooms->agency->name,
                            'price' => 0,
                            'nights' => 0,
                            'room_name' => $agencyrooms->result_room_id,
                            'discount' => $result->percentaje_discount,
                        ];

                        $data[$room->id]['room'] = $room->name;
                        $data[$room->id]['description'] = $room->description;
                        $data[$room->id]['preview_image'] = $room->preview_image;
                        $data[$room->id]['image_or_mateport_url'] = $room->image_or_mateport_url;
                        $data[$room->id]['is_mateport'] = $room->is_mateport;

                        $groupByDate = $agencyrooms->information->groupBy('date_from');
                        $price = 0;
                        $nights = 0;


                        foreach($groupByDate as $keyDate => $dates):
                            $groupByroom = $dates->groupBy('id_site');

                            foreach($groupByroom as $keyRoom =>  $roomAgency):
                                foreach($roomAgency as $priceRoom):
                                
                                    $price  += $priceRoom->price;
                                    $nights  += $priceRoom->nights;
                                endforeach;
                            endforeach;

                            $datesSearch[$keyDate] = $keyDate;
                        endforeach;
                        $totalRoibackPrice = 0;
                        // Validamos para saber en que momento entra al sitio website y así aplicar la tarifa dinámica. 
                        
                        if($agencyrooms->agency->default_site):                                       
                            foreach($response['roomRates'] ?? [] as $roomRates):

                                if($roomRates->roomCode == $room->roiback_room):
                                    $totalRoibackPrice = $request->currency == 'USD' ? ($roomRates->priceBreakdown->finalPrice * $response['currencyConversions']->USD) : $roomRates->priceBreakdown->finalPrice;
                                    $totalNights = count($roomRates->nights);                                    
                                    $data[$room->id]['data']['1'] = [
                                        'agency' => 'Dynamic Rate',
                                        'price' => $totalRoibackPrice,
                                        'nights' => $totalNights,
                                        'room_name' => $room->name,
                                        'discount' => $result->percentaje_discount,
                                    ];
                                else:
                                    $data[$room->id]['data']['1'] = [
                                        'agency' => 'Dynamic Rate',
                                        'price' => 0,
                                        'nights' => 0,
                                        'room_name' => $room->name,
                                        'discount' => $result->percentaje_discount,
                                    ];
                                endif;
                            endforeach;

                            // Aquí solo obtenemos el resultado desde roiback.
                            // $data[$room->id]['data']['1']['price'] =  $totalRoibackPrice > 0 ? (((round($totalRoibackPrice - ($result->percentaje_discount * $totalRoibackPrice)))) ) : 0;
                            $data[$room->id]['data']['1']['price'] =  $totalRoibackPrice > 0 ? round($totalRoibackPrice) : 0;
                            $data[$room->id]['data'][$agencyrooms->agency_id]['agency'] =  $resortSearched->site_name ?? $agencyrooms->agency->name;

                        endif;

                        // Aquí se hace el cálculo para todas las OTAS con el precio correspondiente que nos arrojo en la consulta.
                        $data[$room->id]['data'][$agencyrooms->agency_id]['price'] =  $price > 0 ? (round($price, 1) * (Carbon::parse($request->date[0])->DiffInDays(Carbon::parse($request->date[1])))) : 0;
                        $data[$room->id]['data'][$agencyrooms->agency_id]['nights'] = $nights;
                endforeach;
            endforeach;
        endforeach;

        
        $otherData = $data;
        $newData = [];

        try {
            foreach($data as $keyRoom => $info):
                if($info['data'][1]['price']):
                    foreach($info['data'] as $key => $prices):
                        // esta key es el id que se asigno por default para la tarifa dinámica.

                        if($key == 1):
                            $collection = collect($data[$keyRoom]['data']);

                            // Omitimos los sitios web, ya que no será necesario compararse la tarifa dinámica con el sitio web
                            // aunque podría servir si queremos saber si existe o no una tarifa ya que si no hay nada de tarifas a comparar
                            // y como website en la mayoria de los casos si traerá, este aparecerá primero y sabremos que no habría comparación con la competencia.

                            $maxPrice = $collection->where('agency', '!==', 'Dynamic Rate')
                            ->where('agency', '!==', 'Marival Emotions')
                            ->where('agency', '!==', 'Marival Armony')
                            ->where('agency', '!==', 'Marival Distinct')
                            ->max('price');

                            $minPrice = $collection->where('agency', '!==', 'Dynamic Rate')
                            ->where('agency', '!==', 'Marival Emotions')
                            ->where('agency', '!==', 'Marival Armony')
                            ->where('agency', '!==', 'Marival Distinct')
                            ->min('price');

                            // Filtrar la colección para obtener el elemento con el precio máximo
                            $agencyWithMaxPrice = $collection->firstWhere('price', $maxPrice);
                            $agencyWithMinPrice = $collection->firstWhere('price', $minPrice);

                            // Siempre y cuando la tarifa del dinamic rate sea menor a la agencia con mayor precio, este calculara su valor en base a la tarifa más 
                            // Baja, de lo contrario se asignara lo del valor de la tarifa más alta.

                            if(($info['data'][$key]['price'] < $agencyWithMaxPrice['price']) && $agencyWithMaxPrice['price'] > 0):
                                $info['data'][$key]['price'] = round($info['data'][$key]['price'] - ($info['data'][$key]['price'] * $info['data'][$key]['discount']));
                            
                            elseif($info['data'][$key]['price'] > $agencyWithMaxPrice['price'] && $agencyWithMaxPrice['price'] > 0):
                                $info['data'][$key]['price'] = round($agencyWithMinPrice['price'] - ($agencyWithMinPrice['price'] * $info['data'][$key]['discount']));
                             
                            else:     
                                $info['data'][$key]['price'] = round($info['data'][$key]['price'] - ($info['data'][$key]['price']  * $info['data'][$key]['discount']));                            
                            endif;

                            // Obtener el nombre de la agencia
                            if($agencyWithMaxPrice['price'] > 0):
                                $max = $agencyWithMaxPrice['agency'];
                            else:
                                $max = $resortSearched->site_name ?? 'Website';
                            endif;

                            $newData[1]['data'] = $info['data'][$key];
                            $newData[1]['max_rate'] = $max;

                        else:
                            $newData[1]['agencies'][] = [
                                'agency' => $prices['agency'],
                                'agency_room_name' => $prices['room_name']
                            ];

                        endif;
                    endforeach;

                    $data[$keyRoom]['data'] = $newData;
                    $newData = [];
                else:
                    unset($data[$keyRoom]);
                endif;
            endforeach;
            

        }catch(\Throwable $e) {
            $max = 'No records found';

            foreach($data as $keyRoom => $info):
                foreach($info['data'] as $key => $prices):
    
                    if($key == 1):                       
                        $newData[1] = $prices;
                        $newData[1]['max_rate'] = $max;
                    endif;
                endforeach;
             
                $data[$keyRoom]['data'] = $newData;
            endforeach;
        }

        $newData = [];
        $sum = 0;

        return Inertia::render('Paraty/Dashboard', [
            'resorts' => $resorts ?? [],
            'memberships' => $memberships,
            'membershipsMaster' => $membershipsMaster,
            'data' => $data ?? [],
            'dates' => $datesSearch ?? [],
            'filters' => [
                'date' => $request->date ?? [Carbon::now()->addDays(1)->format('Y-m-d'), Carbon::now()->addDays(7)->format('Y-m-d')], 
                'adults' => $request->adults , 
                'resorts' => $request->resorts ?? 2, 
                'room' => $request->room, 
                'currency' => $request->currency, 
                'memberships_master' => $request->memberships_master ?? 1,
                'membership' => $request->membership ?? 1,
                'category' => $request->category ?? [],
                'childs' => $request->childs ?? '',
                'ages' => $request->ages ?? [],
                'attemps' => $request->attemps ?? 0
            ]
        ]);
    }

    public function processs(Request $request)
    {

        $files = trim(storage_path("app/paraty/process/"));
        $contents = false;

        if(File::exists($files)) {
            $files = collect(File::allFiles($files))->filter(function ($file) {
                return $file->getExtension() == "json";
            });

            // Procesamiento de archivos.
            foreach($files as $file):
                try {
                    $results = json_decode(File::get($file->getRealPath()), true);
                
                    if($results):
                        $batch  = Bus::batch([])->dispatch();
                        $items = array_chunk($results['results'], 1000);

                        foreach($items as $item):
                            $batch->add(new ProccessParatyComparation($item));
                        endforeach;
                    endif;

                    // movemos archivo a la ruta de procesados.
                    File::move($file->getRealPath(), storage_path('app/paraty/proccessed/' . $file->getFilename()));
                   
                } catch (\Throwable $e) {
                    // Sino, movemos el archivo a la ruta de fallidos.
                    File::move($file->getRealPath(), storage_path('app/paraty/failed/' . $file->getFilename()));
                    Log::channel('commandlogs')->info('Error: {error}', ['error' => $e->getMessage()]);
                }

            endforeach;
        }
        dd('Procesado');
    }



    public function comparativePerDay(Request $request)
    {
        $resorts = $this->sites->with(['rooms' => function($rooms) use ($request) {
            $rooms->with(['agencyRooms' => function($agencyRooms) use ($request)  {
                $agencyRooms->with(['information' => function($information) use ($request)  {

                    $information->when($request->date, function($dates, $date) {
                        $dates->where('date_from', '>=', Carbon::parse($date[0])->format('Y-m-d'))
                            ->where('date_from', '<=', Carbon::parse($date[1])->format('Y-m-d'));
                    }, function($dates) {
                        $dates->where('date_from', '>=', Carbon::now()->format('Y-m-d'))
                        ->where('date_from', '<=', Carbon::now()->format('Y-m-d'));
                    });
                },
                'agency' => function($agency) {
                    $agency->select('id', 'agency_id', 'name');
                }]);
            }]);
        }])
        ->where('id', $request->resorts)
        ->get();

        $data = [];
        foreach($resorts as $keyR => $resort):
            foreach($resort->rooms as $roomKey => $room):
                foreach($room->agencyRooms as $agencyrooms):
                        // Eeneramos la estructura de la data, de momento solo ocupamos estos datos
                        $data[$roomKey][$agencyrooms->agency_id] = [
                            'agency' => $agencyrooms->agency->name,
                            'room_name' => $room->name,
                            'dates' => []
                        ];

                        $groupByDate = $agencyrooms->information->groupBy('date_from');
                        foreach($groupByDate as $keyDate => $dates):
                            $groupByroom = $dates->groupBy('raw_room');

                            foreach($groupByroom as $keyRoom =>  $roomAgency):
                                $data[$roomKey][$agencyrooms->agency_id]['dates'][$keyDate] = $roomAgency->sortBy('price')->first();
                            endforeach;

                            $datesSearch[$keyDate] = $keyDate;
                        endforeach;
                endforeach;
            endforeach;
        endforeach;
    }



    public function dashboardback(Request $request)
    {

        $datesSearch = [];
        $resorts = $this->sites->with(['rooms'])->get();

        $results = $this->sites->with(['rooms' => function($rooms) use ($request) {
            $rooms->with(['agencyRooms' => function($agencyRooms) use ($request)  {
                $agencyRooms->with(['information' => function($information) use ($request)  {
                    
                    $information->when($request->date, function($dates, $date) {
                        $dates->where('date_from', '>=', Carbon::parse($date[0])->format('Y-m-d'))
                            ->where('date_from', '<=', Carbon::parse($date[1])->format('Y-m-d'));
                    }, function($dates) {
                        $dates->where('date_from', '>=', Carbon::now()->format('Y-m-d'))
                        ->where('date_from', '<=', Carbon::now()->addDays(6)->format('Y-m-d'));
                    })
                    ->when($request->currency, function($currencies, $currency) {
                        $currencies->where('currency_code', $currency);
                    });
                },
                'agency' => function($agency) {
                    $agency->select('id', 'agency_id', 'name', 'max_or_min');
                }]);
            }])
            ->when($request->room, function($room, $search) {
                $room->where('id', $search);
            });
        }])
        ->where('id', $request->resorts ?? 1)
        ->get();


        $data = [];
        foreach($results as $keyR => $resort):
            foreach($resort->rooms as $roomKey => $room):
                foreach($room->agencyRooms as $agencyrooms):
                        // Generamos la estructura de la data, de momento solo ocupamos estos datos     
                        $data[$room->name]['123'] = [
                            'agency' => 'Inovation',
                            'price' => 0,
                            'nights' => 0
                        ];

                        $data[$room->name][$agencyrooms->agency_id] = [
                            'agency' => $agencyrooms->agency->name,
                            'price' => 0,
                            'nights' => 0
                        ];

                        $groupByDate = $agencyrooms->information->groupBy('date_from');
                        $price = 0;
                        $nights = 0;
                        foreach($groupByDate as $keyDate => $dates):
                            $groupByroom = $dates->groupBy('raw_room');
                            
                            // Esta condicion es para obtener solamente los valores maximos dependiendo si esta configurador.
                            // if($agencyrooms->agency->max_or_min):
                            //     foreach($groupByroom as $keyGroup =>  $group):
                            //         $groupByroom[$keyGroup] = $group->sortBy('price')->last();
                            //     endforeach;

                            // else:
                            //     foreach($groupByroom as $keyGroup =>  $group):
                            //         $groupByroom[$keyGroup] = $group->sortBy('price')->first();
                            //     endforeach;
                            // endif;

                            // dd($agencyrooms->agency, $groupByDate, $groupByroom);

                            // dd($groupByroom);
                            foreach($groupByroom as $keyRoom =>  $roomAgency):
                                foreach($roomAgency as $priceRoom):
                                    $price  += $priceRoom->price;
                                    $nights  += $priceRoom->nights;
                                endforeach;
                            endforeach;

                            $datesSearch[$keyDate] = $keyDate;
                        endforeach;

                        $data[$room->name]['123']['price'] =  $price > 0 ? (number_format( (((round($price, 2) / $nights) * .20) -  round($price, 2) / $nights)  *-1)) : 0;
                        $data[$room->name][$agencyrooms->agency_id]['price'] =  $price > 0 ? (number_format(round($price, 2) / $nights)) : 0;
                        $data[$room->name][$agencyrooms->agency_id]['nights'] = $nights;
                endforeach;
            endforeach;
        endforeach;

        return Inertia::render('Paraty/Dashboard', [
            'resorts' => $resorts ?? [],
            'data' => $data ?? [],
            'dates' => $datesSearch ?? [],
            'filters' => [
                'date' => $request->date ?? [Carbon::now()->format('Y-m-d'), 
                Carbon::now()->addDays(6)->format('Y-m-d')], 
                'adults' => $request->adults , 
                'resorts' => $request->resorts, 
                'room' => $request->room, 
                'currency' => $request->currency,
            ]
        ]);
    }


    public function getRoibackRates ($resortSearched, $request) {

        if($request->date):
            $from = Carbon::parse($request->date[0])->format('Y-m-d');
            $to = Carbon::parse($request->date[1])->format('Y-m-d');

            $childrenAges = '';
            for($x = 0; $x < $request->childs; $x++):
                if($x == intVal($request->childs) -1):
                    $childrenAges = $childrenAges . $request->ages[$x];
                else:
                    $childrenAges = $childrenAges . $request->ages[$x] . ',';
                endif;
            endfor;

            $response = Http::withHeaders([
                'Authorization' => $this->authHeader,
            ])->withoutVerifying()
            ->get("https://api.roiback.com/v0/availability/by-hotels?codes={$resortSearched->roiback_site_name}&checkIn={$from}&checkOut={$to}&country=mx&locale=es&adults={$request->adults}" . ($childrenAges ? "&childrenAges={$childrenAges}" : '') );
            
            $response = collect(json_decode($response->body())[0] ?? []);

            return $response;
        endif;

        // Carbon::now()->format('Y-m-d'), Carbon::now()->addDays(6)->format('Y-m-d')
        return [];

    }

    public function getRoomsCategories(Request $request)
    {
        $categories = RoomsCategory::when($request->resort, function($query, $resort) {
            $query->where('site_id', $resort);
        })
        ->when($request->membership, function($query, $membership) {
            $query->where('membership_id', $membership);
        })
        // where('site_id', $request->resort ?? 1)->where('membership_id', $request->membership)
        ->get();

        return response()->json($categories);
    }
}
