let mix = require('laravel-mix');

/**
 * CMS
 */
mix.js('src/resources/assets/cms/js/app.js', 'src/public/cms/js/')
    .copy('node_modules/@fortawesome/fontawesome-free/webfonts/', 'src/public/cms/webfonts')
    .copy('node_modules/file-icon-vectors/dist/icons/', 'src/public/cms/icons');

/* La propiedad "data" sirve para sobrescribir variables de los SASS */
mix.sass('src/resources/assets/cms/sass/app.scss', 'src/public/cms/css', {data: '@import "./variables/_overrides";' })
    .options({
        /* Evita que las tipografías de FontAwesome se copien a la raíz del paquete */
        processCssUrls: false
    });

mix.copy('node_modules/tinymce/skins', 'src/public/cms/css/tinymce/skins');
