<?php
/* Rutas con el middleware "Web" */
Auth::routes();

/* Sobrescrituras del debug bar */
Route::get('/_debugbar/assets/stylesheets', [
    'as' => 'debugbar-css',
    'uses' => '\Barryvdh\Debugbar\Controllers\AssetController@css'
]);

Route::get('/_debugbar/assets/javascript', [
    'as' => 'debugbar-js',
    'uses' => '\Barryvdh\Debugbar\Controllers\AssetController@js'
]);

Route::get('/_debugbar/open', [
    'as' => 'debugbar-open',
    'uses' => '\Barryvdh\Debugbar\Controllers\OpenController@handler'
]);

/* Rutas operacionales del CMS */
Route::get('/', 'Frontend\PageController@index')->name('home');
Route::post('forms/handler', 'Frontend\FormsHandlerController')->name('forms.handler');
Route::post('services/tours/reservation', 'Frontend\PageController@tour')->name('reservation.tour');
Route::get('find-rooms-price', 'Frontend\PageController@roomPrices')->name('rooms.price');
Route::get('total-blackout-dates', 'Frontend\PageController@blackoutDates')->name('blackoutDates');
Route::get('/hotels', 'Frontend\PageController@rooms');
Route::resource('/gbsres-specialoffers', 'Frontend\ApiController');
Route::get('banners/actives/{lang}', 'Frontend\BannersController')->name('banners.actives');
Route::get('siteindex.xml', 'Frontend\PageController@renderSitemap')->name('sitemap.index');
Route::get('sitemap_{lang}.xml', 'Frontend\PageController@renderSitemap')->name('sitemap.lang');
Route::get('{slug1?}/{slug2?}/{slug3?}/{slug4?}', 'Frontend\PageController@index')->where(['slug1' => '^(?!.?(admin|cms|api)).*']);
Route::get('/cms/{asset}', 'Frontend\AssetsController@show')->where(['asset' => '.*'])->name('cms-public');
Route::post('/api-newsletter-add', 'Frontend\NewsletterController@addUserToList');
