<?php
use AvengersMG\MGCms2019\App\Cms\Sites\Site;
use AvengersMG\MGCms2019\App\Cms\Pages\Page;

/*
|--------------------------------------------------------------------------
| Admin Breadcrumbs
|--------------------------------------------------------------------------
*/

/************+*
 *   SITES    |
**************/

Breadcrumbs::register('admin.index', function ($breadcrumbs) {
    $breadcrumbs->push('Admin', route('admin.index'));
});


Breadcrumbs::register('sites.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.index');
    $breadcrumbs->push('Sites', route('sites.index'));
});


Breadcrumbs::register('sites.create', function ($breadcrumbs) {
    $breadcrumbs->parent('sites.index');
    $breadcrumbs->push('Crear sitio', route('sites.create'));
});


Breadcrumbs::register('sites.show', function ($breadcrumbs, Site $site, $lang) {
    $breadcrumbs->parent('sites.index');
    $breadcrumbs->push($site->name, route('sites.show', [$site, $lang]));
});

/************+**
 *   PAGES     |
 **************/

Breadcrumbs::register('pages.index', function ($breadcrumbs, Site $site) {
    $breadcrumbs->parent('sites.show', $site, app()->getLocale());
    $breadcrumbs->push('Páginas', route('pages.index', $site));
});

Breadcrumbs::register('pages.index-from-current', function ($breadcrumbs) {
    $breadcrumbs->push('Páginas', route('pages.index-from-current'));
});

Breadcrumbs::register('pages.create', function ($breadcrumbs, Site $site) {
    $breadcrumbs->parent('pages.index', $site);
    $breadcrumbs->push('Crear Página', route('pages.create', $site));
});

Breadcrumbs::register('pages.create-from-current', function ($breadcrumbs) {
    $breadcrumbs->parent('pages.index-from-current');
    $breadcrumbs->push('Crear Página', route('pages.create-from-current'));
});

Breadcrumbs::register('pages.addNode', function ($breadcrumbs, Page $page) {
    $breadcrumbs->parent('pages.index', $page->site);
    $breadcrumbs->push('Añadir Página', route('pages.addNode', $page));
});

Breadcrumbs::register('pages.show', function ($breadcrumbs, Page $page, $lang) {
    $breadcrumbs->parent('pages.index', $page->site, app()->getLocale());
    $breadcrumbs->push($page->translateOrDefault('es')->name, route('pages.show', [$page, $lang]));
});

/************+**
 *   USERS     |
 **************/

Breadcrumbs::register('users.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.index');
    $breadcrumbs->push('Usuarios', route('users.index'));
});

Breadcrumbs::register('users.create', function ($breadcrumbs) {
    $breadcrumbs->parent('users.index');
    $breadcrumbs->push('Crear usuario', route('users.create'));
});

Breadcrumbs::register('users.edit', function ($breadcrumbs, $user) {
    $breadcrumbs->parent('users.index');
    $breadcrumbs->push($user->name, route('users.edit', $user));
});


/************+**
 *   ROLES     |
 **************/

Breadcrumbs::register('roles.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.index');
    $breadcrumbs->push('Roles', route('roles.index'));
});

Breadcrumbs::register('roles.create', function ($breadcrumbs) {
    $breadcrumbs->parent('roles.index');
    $breadcrumbs->push('Crear Rol', route('roles.create'));
});

Breadcrumbs::register('roles.edit', function ($breadcrumbs, $role) {
    $breadcrumbs->parent('roles.index');
    $breadcrumbs->push($role->name, route('roles.edit', $role));
});


Breadcrumbs::register('roles.show', function ($breadcrumbs, $role) {
    $breadcrumbs->parent('roles.index');
    $breadcrumbs->push('Permisos para: '.$role->name, route('roles.show', $role));
});

/************+**
 *   ROLES     |
 **************/

Breadcrumbs::register('permissions.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.index');
    $breadcrumbs->push('Permisos', route('permissions.index'));
});

Breadcrumbs::register('permissions.create', function ($breadcrumbs) {
    $breadcrumbs->parent('permissions.index');
    $breadcrumbs->push('Crear Permiso', route('permissions.create'));
});

Breadcrumbs::register('permissions.edit', function ($breadcrumbs, $permission) {
    $breadcrumbs->parent('permissions.index');
    $breadcrumbs->push($permission->name, route('permissions.edit', $permission));
});

/************+**
 *   Positions |
 **************/
Breadcrumbs::register('position.home', function ($breadcrumbs) {
    $breadcrumbs->push('positions', route('position.home'));
});

Breadcrumbs::register('position.index', function ($breadcrumbs, Page $page) {
    $breadcrumbs->parent('position.home');
    $breadcrumbs->push($page->name, route('position.index', $page->id));
});

Breadcrumbs::register('position.create', function ($breadcrumbs, Page $page) {
    $breadcrumbs->parent('position.index', $page);
    $breadcrumbs->push('Add', route('position.create', $page->id));
});

Breadcrumbs::register('filetypes.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.index');
    $breadcrumbs->push('File types', route('filetypes.index'));
});

Breadcrumbs::register('filetypes.create', function ($breadcrumbs) {
    $breadcrumbs->parent('filetypes.index');
    $breadcrumbs->push('Crear Permiso', route('filetypes.create'));
});

Breadcrumbs::register('filetypes.edit', function ($breadcrumbs, $file) {
    $breadcrumbs->parent('filetypes.index');
    $breadcrumbs->push($file->type, route('filetypes.edit', $file));
});

/************+*****
 *   MEDIAFILES   |
 *****************/

Breadcrumbs::register('mediafiles.index', function ($breadcrumbs, Site $site) {
    $breadcrumbs->parent('sites.show', $site, app()->getLocale());
    $breadcrumbs->push('Media files', route('mediafiles.index', $site));
});

Breadcrumbs::register('mediafiles.index-from-current', function ($breadcrumbs) {
    $breadcrumbs->push('Media files', route('mediafiles.index-from-current'));
});

Breadcrumbs::register('mediafiles.show.dir', function ($breadcrumbs, Site $site, $dir) {
    $breadcrumbs->parent('mediafiles.index', $site);
    $breadcrumbs->push('Media files', route('mediafiles.show.dir', [$site, $dir]));
});

Breadcrumbs::register('mediafiles.show.dir-from-current', function ($breadcrumbs, $dir) {
    $breadcrumbs->push('Media files', route('mediafiles.show.dir-from-current', $dir));
});

/************+*****
 *   AMENITIES    |
 *****************/

Breadcrumbs::register('amenities.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.index');
    $breadcrumbs->push('Amenities', route('amenities.index'));
});

Breadcrumbs::register('amenities.create', function ($breadcrumbs) {
    $breadcrumbs->parent('amenities.index');
    $breadcrumbs->push('Crear amenity', route('amenities.create'));
});

Breadcrumbs::register('amenities.edit', function ($breadcrumbs, $amenity) {
    $breadcrumbs->parent('amenities.index');
    $breadcrumbs->push($amenity->name, route('amenities.edit', $amenity->id));
});

/************+****
 *  CATEGORIES   |
 ****************/

Breadcrumbs::register('categories.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.index');
    $breadcrumbs->push('Categories', route('categories.index'));
});

Breadcrumbs::register('categories.create', function ($breadcrumbs) {
    $breadcrumbs->parent('categories.index');
    $breadcrumbs->push('Crear category', route('categories.create'));
});

Breadcrumbs::register('categories.edit', function ($breadcrumbs, $category) {
    $breadcrumbs->parent('categories.index');
    $breadcrumbs->push($category->category, route('categories.edit', $category->id));
});


/************+****
 *     ROOMS     |
 ****************/

Breadcrumbs::register('rooms.create', function ($breadcrumbs, Page $page, $locale) {
    $breadcrumbs->parent('pages.show', $page, $locale);
    $breadcrumbs->push('Crear habitacion', route('rooms.create', [$page, $locale]));
});

/************+*******
 *     SPECIALS     |
 *******************/

Breadcrumbs::register('specials.create', function ($breadcrumbs, Page $page, $lang) {
    $breadcrumbs->parent('pages.show', $page, $lang);
    $breadcrumbs->push('Crear Special', route('rooms.create', [$page, $lang]));
});

/*****************
 *     TOURS     |
 ****************/

Breadcrumbs::register('tours.create', function ($breadcrumbs, Page $page, $lang) {
    $breadcrumbs->parent('pages.show', $page, $lang);
    $breadcrumbs->push('Crear Tours', route('tours.create', [$page, $lang]));
});

/*****************
 *     RESTAURANTS     |
 ****************/

Breadcrumbs::register('restaurant.create', function ($breadcrumbs, Page $page, $lang) {
    $breadcrumbs->parent('pages.show', $page, $lang);
    $breadcrumbs->push('Crear Restaurante', route('restaurant.create', [$page, $lang]));
});

/************+*****
 *   SERVICES    |
 *****************/

Breadcrumbs::register('services.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.index');
    $breadcrumbs->push('services', route('services.index'));
});
Breadcrumbs::register('services.create', function ($breadcrumbs) {
    $breadcrumbs->parent('services.index');
    $breadcrumbs->push('Crear service', route('services.create'));
});

Breadcrumbs::register('services.edit', function ($breadcrumbs, $service) {
    $breadcrumbs->parent('services.index');
    $breadcrumbs->push($service->name, route('services.edit', $service->id));
});

/*****************
 *     Forms     |
 ****************/

Breadcrumbs::register('forms.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.index');
    $breadcrumbs->push('Forms', route('forms.index'));
});

Breadcrumbs::register('forms.create', function ($breadcrumbs) {
    $breadcrumbs->parent('forms.index');
    $breadcrumbs->push('Crear Form', route('forms.create'));
});

Breadcrumbs::register('forms.edit', function ($breadcrumbs, $form) {
    $breadcrumbs->parent('forms.index');
    $breadcrumbs->push($form->name, route('forms.edit', $form));
});

/*********************
 *     RELATIONS     |
 ********************/

Breadcrumbs::register('relations.create', function ($breadcrumbs, Page $page, $lang) {
    $breadcrumbs->parent('pages.show', $page, $lang);
    $breadcrumbs->push('Agregar relacion', route('relations.create', [$page, $lang]));
});

/*********************
 *      GALLERY      |
 ********************/

Breadcrumbs::register('galleries.create', function ($breadcrumbs, Page $page, $lang) {
    $breadcrumbs->parent('pages.show', $page, $lang);
    $breadcrumbs->push('Create Gallery', route('galleries.create', [$page, $lang]));
});

Breadcrumbs::register('galleries.edit', function ($breadcrumbs, $gallery, Page $page, $lang) {
    $breadcrumbs->parent('pages.show', $page, $lang);
    $breadcrumbs->push('Edit ' . $gallery->name, route('galleries.create', [$page, $lang]));
});

Breadcrumbs::register('galleries.reorder', function ($breadcrumbs, $gallery, Page $page) {
    $breadcrumbs->parent('pages.show', $page, app()->getLocale());
    $breadcrumbs->push($gallery->name, route('galleries.reorder', [$gallery]));
});

/*********************
 *       CARDS       |
 ********************/

Breadcrumbs::register('cards.create', function ($breadcrumbs, Page $page, $lang) {
    $breadcrumbs->parent('pages.show', $page, $lang);
    $breadcrumbs->push('Create Card', route('cards.create', [$page, $lang]));
});

Breadcrumbs::register('cards.edit', function ($breadcrumbs, Page $page, $card, $lang) {
    $breadcrumbs->parent('pages.show', $page, $lang);
    $breadcrumbs->push('Edit ' . $card->title, route('cards.edit', [$card, $lang]));
});

Breadcrumbs::register('cards.index', function ($breadcrumbs, Page $page) {
    $breadcrumbs->parent('pages.show', $page, 'en');
    $breadcrumbs->push('Reorder cards', route('cards.index', $page));
});

/*********************
 *       BANNERS     |
 ********************/

Breadcrumbs::register('banners.index', function ($breadcrumbs) {
    $breadcrumbs->push('Banners', route('banners.index'));
});

Breadcrumbs::register('banners.create', function ($breadcrumbs) {
    $breadcrumbs->parent('banners.index');
    $breadcrumbs->push('Banners', route('banners.create'));
});

Breadcrumbs::register('banners.edit', function ($breadcrumbs, $banner, $lang) {
    $breadcrumbs->parent('banners.index');
    $breadcrumbs->push($banner->translateOrDefault()->name, route('banners.edit', [$banner, $lang]));
});


/***********************
 *       REVIEWS       |
 **********************/

Breadcrumbs::register('reviews.index', function ($breadcrumbs) {
    $breadcrumbs->push('Reviews', route('reviews.index'));
});

Breadcrumbs::register('reviews.create', function ($breadcrumbs) {
    $breadcrumbs->parent('reviews.index');
    $breadcrumbs->push('Reviews', route('reviews.create'));
});

Breadcrumbs::register('reviews.edit', function ($breadcrumbs, $review) {
    $breadcrumbs->parent('reviews.index');
    $breadcrumbs->push($review->name, route('reviews.edit', $review));
});

/************+*****
 * REDES SOCIALES |
 *****************/

Breadcrumbs::register('socialmedias.index', function ($breadcrumbs) {
    $breadcrumbs->parent('admin.index');
    $breadcrumbs->push('socialmedias', route('socialmedias.index'));
});

Breadcrumbs::register('socialmedias.create', function ($breadcrumbs) {
    $breadcrumbs->parent('socialmedias.index');
    $breadcrumbs->push('Crear Red Social', route('socialmedias.create'));
});

Breadcrumbs::register('socialmedias.edit', function ($breadcrumbs, $socialmedia) {
    $breadcrumbs->parent('socialmedias.index');
    $breadcrumbs->push($socialmedia->description, route('socialmedias.edit', $socialmedia->id));
});
