<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware(['client'])->group(function () {
    Route::get('find-rooms-price', 'Frontend\ApiController@roomPrices')->name('rooms.price.publish');
    Route::get('total-blackout-dates', 'Frontend\ApiController@blackoutDates')->name('blackoutDates.publish');

    /* Grupo para especiales */
    Route::prefix('specials')->group(function (){
        Route::get('/', 'Frontend\ApiController@specials')->name('specials.publish');
        /* Alias de "special", para mantener consistencia */
        Route::get('single', 'Frontend\ApiController@special');
    });
    Route::get('special', 'Frontend\ApiController@special')->name('specials.single.publish');


    /* Grupo para restaurantes */
    Route::prefix('restaurants')->group(function () {
        Route::get('/', 'Frontend\ApiController@restaurants')->name('restaurants.publish');
    });
    
    /* Grupo para habitaciones */
    Route::prefix('rooms')->group(function () {
        Route::get('/', 'Frontend\ApiController@rooms')->name('rooms.publish');
    });

    /* Grupo para páginas */
    Route::prefix('pages')->group(function () {
        /* Este método no envía todas las páginas, sino solo las pedidas */
        Route::get('/multiple', 'Frontend\ApiController@pagesByPermalinks')->name('pages.multiple.publish');
    });
    
});
