<?php

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin routes for the application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group and auth middleware. Now create something great!
|
*/
Route::prefix('admin')->group(function () {
    Route::get('/', 'AdminController')->name('admin.index');

    /*
    |--------------------------------------------------------------------------
    | Admin For users administrations
    |--------------------------------------------------------------------------
    |
    */

    /**
     * USERS
     */
    Route::resource('users', 'Users\UsersController');

    /**
     * ROLES
     */
    Route::resource('roles', 'Roles\RolesController');
    Route::post('roles/attach-roles/{role}', 'Roles\RolesController@attachPermissions')->name('roles.permissions');

    /**
     * Import Availabilities
     */
    //Route::get('imports', 'Availability\AvailabilityController@import');
    Route::resource('import', 'Availability\AvailabilityController');
    Route::get('importar', 'Availability\AvailabilityController@importExcel');
    /**
     * PERMISSIONS
     */
    Route::resource('permissions', 'Permisions\PermisionsController')->except('show');

    /**
     * FILES TYPES
     */

    Route::resource('filetypes', 'Mediafiles\FileTypesController')->except('show');

    /*
    |--------------------------------------------------------------------------
    | Admin Sites administration
    |--------------------------------------------------------------------------
    |
    */

    //gallery
    //    Route::resource('galleries', 'Components\GalleryController');
    //
    Route::prefix('galleries')->group(function () {
        Route::get('create/{page?}', 'Components\GalleryController@create')->name('galleries.create');
        Route::post('/', 'Components\GalleryController@store')->name('galleries.store');
        Route::put('update/{gallery}', 'Components\GalleryController@update')->name('galleries.update');
        Route::get('edit/{gallery}', 'Components\GalleryController@edit')->name('galleries.edit');
        Route::get('reorder/{gallery}', 'Components\GalleryController@reorder')->name('galleries.reorder');
        Route::put('update-gallery/{gallery}', 'Components\GalleryController@updateGallery')->name('galleries.update.gallery');
        Route::delete('delete/{gallery}', 'Components\GalleryController@destroy')->name('galleries.delete');

        /* NOTA: ¿No sería conveniente cambiar las URLs a {modelo}/{id}/{acción}? muchas URL tienen la acción antes que el ID ({modelo}/{acción}/{id}) y están mezclados los estilos */
        Route::get('extra-mediafiles/{gallery}', 'Components\GalleryController@extraMediafiles')->name('galleries.extra-mediafiles');
        Route::get('extra-mediafiles/from-page/{page}', 'Components\GalleryController@extraMediafiles')->name('galleries.from-page.extra-mediafiles');
        Route::put('from-page/reorder/{page}', 'Components\GalleryController@reorderFromPage')->name('galleries.from-page.reorder');
    });

    /**
     *
     * ROOMS
     */

    Route::resource('amenities', 'Accommodations\AmenitiesController')->except('show');
    Route::resource('categories', 'Accommodations\CategoriesController')->except('show');
    Route::resource('rooms', 'Accommodations\RoomsController')->except(['index','edit', 'create', 'show', 'destroy']);
    Route::get('pages/{page}/create/room/{lang}', 'Accommodations\RoomsController@create')->name('rooms.create');
    Route::get('rooms/{room}/{index}', 'Accommodations\RoomsController@show')->name('rooms.show');
    /* NOTA: ¿No sería conveniente cambiar las URLs a {modelo}/{id}/{acción}? muchas URL tienen la acción antes que el ID ({modelo}/{acción}/{id}) y están mezclados los estilos */
    Route::delete('rooms/delete/{room}/{lang}', 'Accommodations\RoomsController@destroy')->name('rooms.destroy');

    /**
     *
     * BANNERS
     */
    Route::resource('banners', 'Banners\BannersController')->except('edit');
    Route::get('banners/{banner}/edit/{lang}', 'Banners\BannersController@edit')->name('banners.edit');
    Route::get('banners/urls/{lang}', 'Banners\BannersController@urls')->name('urls.pages');

    /**
     * REVIEWS
     */
    Route::resource('reviews', 'Reviews\ReviewsController')->except('show');

    /**
     *
     * SPECIALS
     */
    Route::resource('specials', 'Specials\SpecialController')->only(['store', 'update']);
    Route::get('pages/{page}/create/special/{lang}', 'Specials\SpecialController@create')->name('specials.create');
    /* NOTA: ¿No sería conveniente cambiar las URLs a {modelo}/{id}/{acción}? muchas URL tienen la acción antes que el ID ({modelo}/{acción}/{id}) y están mezclados los estilos */
    Route::delete('specials/delete/{special}/{lang}', 'Specials\SpecialController@destroy')->name('specials.destroy');

    /**
     * TOURS
     */
    Route::resource('tours', 'Tours\ToursController')->only(['store', 'update']);
    Route::get('pages/{page}/create/tour/{lang}', 'Tours\ToursController@create')->name('tours.create');
    /* NOTA: ¿No sería conveniente cambiar las URLs a {modelo}/{id}/{acción}? muchas URL tienen la acción antes que el ID ({modelo}/{acción}/{id}) y están mezclados los estilos */
    Route::delete('tours/delete/{tour}/{lang}', 'Tours\ToursController@destroy')->name('tours.destroy');

    /**
     * Restaurants
     */

    Route::resource('restaurants', 'Restaurants\RestaurantController')->only(['store','update']);
    Route::get('pages/{page}/create/restaurant/{lang}', 'Restaurants\RestaurantController@create')->name('restaurant.create');
    Route::resource('services', 'Restaurants\ServiceController')->except('show');
    Route::get('restaurants/{restaurant}/{id}/{lang}', 'Restaurants\RestaurantController@show')->name('restaurants.show');

    /* NOTA: ¿No sería conveniente cambiar las URLs a {modelo}/{id}/{acción}? muchas URL tienen la acción antes que el ID ({modelo}/{acción}/{id}) y están mezclados los estilos */
    Route::delete('restaurants/{restaurant}/delete/{lang}', 'Restaurants\RestaurantController@destroy')->name('restaurants.destroy');

    /**
     * CARDS
     */
    Route::resource('cards', 'Components\CardController')->only(['store', 'update', 'destroy']);
    Route::get('pages/{page}/create/card/{lang}', 'Components\CardController@create')->name('cards.create');
    Route::get('cards/{card}/{lang}', 'Components\CardController@edit')->name('cards.edit');
    Route::get('cards/{page}', 'Components\CardController@index')->name('cards.index');
    Route::put('cards/update/priority/{page}', 'Components\CardController@priority')->name('cards.update.priority');

    /* NOTA: ¿No sería conveniente cambiar las URLs a {modelo}/{id}/{acción}? muchas URL tienen la acción antes que el ID ({modelo}/{acción}/{id}) y están mezclados los estilos */
    Route::get('cards/extra-mediafiles/{card}/{lang}', 'Components\CardController@extraMediafiles')->name('cards.extra-mediafiles');
    Route::get('cards/extra-mediafiles/from-page/{page}/{lang}', 'Components\CardController@extraMediafiles')->name('cards.from-page.extra-mediafiles');


    /**
     * SITES
     */
    Route::resource('sites', 'Sites\SitesController')->except('edit', 'show');
    Route::get('sites/{site}/{lang}', 'Sites\SitesController@show')->name('sites.show');

    /**
    * PAGES
    */
    Route::prefix('pages')->group(function () {
        Route::get('/', 'Pages\PagesController@index')->name('pages.index-from-current');
        Route::post('/', 'Pages\PagesController@store')->name('pages.store-from-current');
        Route::get('create', 'Pages\PagesController@create')->name('pages.create-from-current');
        Route::get('update-permalinks', 'Pages\PagesController@updatePermaLinks')->name('update.permalinks-from-current');
        Route::get('permalinks', 'Pages\PagesController@permalinks')->name('pages.permalink-from-current');
        Route::get('{page}/{lang}', 'Pages\PagesController@show')->name('pages.show');
        Route::put('seo/{page}', 'Pages\PagesController@updateSeo')->name('pages.updateSeo');
        Route::put('update-tree', 'Pages\PagesController@updateTree')->name('pages.tree');
        Route::post('upload/file', 'Pages\PagesController@upload')->name('page.upload.file');
        Route::post('update/file', 'Mediafiles\MediaFilesController@fileUpdate')->name('files.update');
        Route::get('file/{mediafile}/{lang?}', 'Pages\PagesController@getMedia')->name('page.get.file');
        Route::put('{page}', 'Pages\PagesController@update')->name('pages.update');
        Route::delete('{page}', 'Pages\PagesController@destroy')->name('pages.destroy');
        Route::get('{page}/create', 'Pages\PagesController@create')->name('pages.addNode');
        Route::get('list', 'Pages\PagesController@list')->name('pages.list');

        /* NOTA: ¿No sería conveniente cambiar las URLs a {modelo}/{id}/{acción}? muchas URL tienen la acción antes que el ID ({modelo}/{acción}/{id}) y están mezclados los estilos */
        Route::delete('{page}/translations/delete/{lang}', 'Pages\PagesController@destroyTranslation')->name('pages.translations.destroy');
        /**
         *  PAGE RELATIONS PAGE
         */
        Route::resource('relations', 'Pages\RelationPagesController')->except(['show','index', 'create']);
        Route::get('{page}/relations/{lang}', 'Pages\RelationPagesController@create')->name('relations.create');
    });


    /**
     * PAGES FROM SITES
     */
    Route::prefix('sites')->group(function () {
        Route::get('{site}/pages', 'Pages\PagesController@index')->name('pages.index');
        Route::post('{site}/pages', 'Pages\PagesController@store')->name('pages.store');
        Route::get('{site}/pages/create', 'Pages\PagesController@create')->name('pages.create');
        Route::get('{site}/mediafiles/browse', 'Mediafiles\MediaFilesController@index')->name('mediafiles.index');
        Route::get('{site}/mediafiles/browse/{dir}', 'Mediafiles\MediaFilesController@showDir')->where(['dir' => '.*'])->name('mediafiles.show.dir');
        Route::get('{site}/permalinks', 'Pages\PagesController@permalinks')->name('pages.permalink');
        Route::get('{site}/update-permalinks', 'Pages\PagesController@updatePermaLinks')->name('update.permalinks');
    });

    /**
     * MEDIAFILES
     */
    Route::prefix('mediafiles')->group(function () {
        Route::get('browse', 'Mediafiles\MediaFilesController@index')->name('mediafiles.index-from-current');
        Route::post('/', 'Mediafiles\MediaFilesController@store')->name('mediafiles.store');
        Route::get('/{mediafile}/{lang?}', 'Mediafiles\MediaFilesController@show')->name('mediafiles.show');
        Route::put('/{mediafile}', 'Mediafiles\MediaFilesController@update')->name('mediafiles.update');
        Route::delete('/{mediafile}', 'Mediafiles\MediaFilesController@destroy')->name('mediafiles.destroy');
        Route::get('browse/{dir}', 'Mediafiles\MediaFilesController@showDir')->where(['dir' => '.*'])->name('mediafiles.show.dir-from-current');
        Route::post('create-dir', 'Mediafiles\MediaFilesController@createDir')->name('mediafiles.create.dir');
        Route::delete('/{mediafile}/{lang}', 'Mediafiles\MediaFilesController@destroyTranslation')->name('mediafiles.translations.destroy');
    });

    /**
     * RUTA PARA CAMBIAR EL LENGUAJE EN EL BACKEND
     */
    Route::get('change-language/{lang}', 'Pages\PagesController@language')->name('change.language');

    /**
     * FORMULARIOS
     */
    Route::resource('forms', 'Forms\FormsController')->except('show');

    /**
     * Services Form Request
     */
    Route::resource('form-services', 'Forms\FormRequestController');

    /**
     * Redes Sociales
     */
    Route::resource('socialmedias', 'Socialmedias\SocialmediasController')->except('show');
});
