@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $role) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h3>Asignar permisos a <span class="text-aqua">{{ $role->name }}</span></h3>
                    <div class="col-md-12 text-right">
                        @can('viewAny', Spatie\Permission\Models\Role::class)
                        <a href="{{ route('roles.index') }}" class="btn btn-primary">Regresar a Roles</a>
                        @endcan
                    </div>
                </div>
                <div class="box-body">
                    @include('MGCms2019::admin.partials.formErrors')
                    {!! Form::open(['route' => ['roles.permissions', $role], 'method' => 'POST']) !!}

                    <div class="form-group">
                    @foreach($permissions as $permission)
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" name="permissions[]" value="{{ $permission->id }}" {{ (in_array($permission->name, $role_permissions)) ? 'checked' : '' }}>
                                {{ ucwords($permission->name) }}
                            </label>
                        </div>
                    @endforeach
                    </div>
                    @can('update', $role)
                    <button type="submit" class="btn btn-info">Asignar</button>
                    @endcan

                    {!! Form::close() !!}
                </div>

            </div>
        </div>
    </div>
@endsection
