@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">Roles</h3>
                    <div class="col-md-12 text-right">
                        @can('create', Spatie\Permission\Models\Role::class)
                        <a href="{{ route('roles.create') }}" class="btn btn-primary">Add Role</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body">
                  @include('MGCms2019::admin.partials.formErrors')

                  <div class="col-md-12">
                    <table class="table table-bordered table-striped generalTable">
                        <thead>
                        <tr>
                            <th>#ID</th>
                            <th>Name</th>
                            <th>Guard</th>
                            <th>Permisos</th>
                            <th>Fecha de creacion</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($roles as $role)
                        <tr>
                            <td>{{ $role->id }}</td>
                            <td>{{ $role->name }}</td>
                            <td>{{ $role->guard_name }}</td>
                            <td>
                                @foreach($role->permissions as $permission)
                                    <span class="badge bg-aqua">{{ $permission->name }}</span>
                                @endforeach
                            </td>
                            <td>{{ $role->created_at }}</td>
                            <td class="text-center">
                                @can('update', $role)
                                <a href="{{ route('roles.show', $role) }}" class="btn btn-info btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Add permissions"><i class="fa fa-unlock"></i></a>
                                <a href="{{ route('roles.edit', $role) }}" class="btn btn-success btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Edit permission"><i class="fa fa-edit"></i></a>
                                @endcan
                                @can('delete', $role)
                                <a href="{{ route('roles.destroy', $role) }}" class="btn btn-danger btn-xs tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Delete permission"><i class="fas fa-window-close"></i></a>
                                @endcan
                            </td>
                        </tr>
                        @endforeach

                        </tbody>
                        <tfoot>
                        <tr>
                            <th>#ID</th>
                            <th>Name</th>
                            <th>Guard</th>
                            <th>Created at</th>
                            <th>Actions</th>
                        </tr>
                        </tfoot>
                    </table>
                  </div>
                </div>
            </div>
        </div>
    </div>


@endsection
