@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $role) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h3>Editar Rol</h3>
                    <div class="col-md-12 text-right">
                        @can('viewAny', Spatie\Permission\Models\Role::class)
                        <a href="{{ route('roles.index') }}" class="btn btn-primary">Regresar a Roles</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body">
                    @include('MGCms2019::admin.partials.formErrors')
                    {!! Form::model($role, ['route' => ['roles.update', $role], 'method' => 'PUT']) !!}
                    @include('MGCms2019::admin.users.partials.form')
                    @can('update', $role)
                    <div class="box-footer text-right">
                        <button type="submit" class="btn btn-info">Actualizar</button>
                    </div>
                    @endcan
                    {!! Form::close() !!}
                </div>

            </div>
        </div>
    </div>
@endsection
