@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h3>Crear Rol</h3>
                    <div class="col-md-12 text-right">
                        @can('viewAny', Spatie\Permission\Models\Role::class)
                        <a href="{{ route('roles.index') }}" class="btn btn-primary">Regresar a Roles</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body">
                    @include('MGCms2019::admin.partials.formErrors')
                    {!! Form::open(['route' => 'roles.store', 'methods' => 'post']) !!}
                    @include('MGCms2019::admin.users.partials.form')
                    @can('create', Spatie\Permission\Models\Role::class)
                    <div class="box-footer text-right">
                        <button type="submit" class="btn btn-info">Crear</button>
                    </div>
                    @endcan
                    {!! Form::close() !!}
                </div>

            </div>
        </div>
    </div>
@endsection
