@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <h3 class="box-title">Permisos</h3>
                    <div class="col-md-12 text-right">
                        @can('create', Spatie\Permission\Models\Permission::class)
                        <a href="{{ route('permissions.create') }}" class="btn btn-primary">Agregar Permiso</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body">
                  @include('MGCms2019::admin.partials.formErrors')
                  <div class="col-md-12">
                    <table class="table table-bordered table-striped generalTable">
                        <thead>
                        <tr>
                            <th>#ID</th>
                            <th>Name</th>
                            <th>Guard</th>
                            <th>Created at</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($permissions as $permission)
                        <tr>
                            <td>{{ $permission->id }}</td>
                            <td>{{ $permission->name }}</td>
                            <td>{{ $permission->guard_name }}</td>
                            <td>{{ $permission->created_at }}</td>
                            <td class="text-center">
                                @can('update', $permission)
                                <a href="{{ route('permissions.edit', $permission) }}" class="btn btn-success btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Edit permission"><i class="fa fa-edit"></i></a>
                                @endcan
                                @can('delete', $permission)
                                <a href="{{ route('permissions.destroy', $permission) }}" class="btn btn-danger btn-xs tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Delete permission"><i class="fas fa-window-close"></i></a>
                                @endcan
                            </td>
                        </tr>
                        @endforeach

                        </tbody>
                        <tfoot>
                        <tr>
                            <th>#ID</th>
                            <th>Name</th>
                            <th>Guard</th>
                            <th>Created at</th>
                            <th>Actions</th>
                        </tr>
                        </tfoot>
                    </table>
                  </div>
                </div>
            </div>
        </div>
    </div>

@endsection
