@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $permission) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h3>Editar Permiso <span class="text-aqua"> {{ $permission->name }} </span></h3>
                    <div class="col-md-12 text-right">
                        @can('viewAny', Spatie\Permission\Models\Permission::class)
                        <a href="{{ route('permissions.index') }}" class="btn btn-primary">Regresar a permisos</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body">
                    @include('MGCms2019::admin.partials.formErrors')
                    {!! Form::model($permission, ['route' => ['permissions.update', $permission], 'method' => 'PUT']) !!}
                    @include('MGCms2019::admin.users.partials.form')
                    @can('update', Spatie\Permission\Models\Permission::class)
                    <div class="box-footer text-right">
                        <button type="submit" class="btn btn-info">Actualizar</button>
                    </div>
                    @endcan
                    {!! Form::close() !!}
                </div>

            </div>
        </div>
    </div>
@endsection
