@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class11"box-header">
                    <div class="col-md-12 text-right">
                        @can('create', AvengersMG\MGCms2019\App\Cms\Users\User::class)
                        <a href="{{ route('users.create') }}" class="btn btn-primary">Agregar usuario</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body" id="usser-tables">
                    @include('MGCms2019::admin.partials.formErrors')

                    <div class="col-md-12">
                        <table class="table table-hover generalTable username-table">
                            <thead class="table-info">
                            <tr>
                                <th>#ID</th>
                                <th>Name</th>
                                <th>Username</th>
                                <th>e-mail</th>
                                <th>Roles</th>
                                <th>Sites</th>
                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($users as $user)
                                <tr>
                                    <td>{{ $user->id }}</td>
                                    <td>{{ $user->name }}</td>
                                    <td>{{ $user->username }}</td>
                                    <td>{{ $user->email }}</td>
                                    <td class="text-center">
                                        @foreach($user->roles as $role)
                                            <span class="badge bg-aqua">{{ $role->name }}</span>
                                        @endforeach
                                    </td>
                                    <td>
                                        @foreach($user->sites as $site)
                                            <span class="badge bg-aqua">{{ $site->name }}</span>
                                        @endforeach
                                    </td>
                                    <td class="text-center">
                                        @can('view', $user)
                                        <a href="{{ route('users.show', $user) }}" class="btn btn-info btn-sm tooltip-item" data-toggle="tooltip" data-placement="top" title="Ver actividad"><i class="fa fa-eye"></i></a>
                                        @endcan
                                        @can('update', $user)
                                        <a href="{{ route('users.edit', $user) }}" class="btn btn-success btn-sm tooltip-item" data-toggle="tooltip" data-placement="top" title="Editar"><i class="fa fa-edit"></i></a>
                                        @endcan
                                        @can('delete', $user)
                                        <a href="{{ route('users.destroy', $user) }}" class="btn btn-danger btn-sm tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Eliminar"><i class="fas fa-times"></i></a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach

                            </tbody>
                            <tfoot class="table-info">
                            <tr>
                                <th>#ID</th>
                                <th>Name</th>
                                <th>Username</th>
                                <th>e-mail</th>
                                <th>Roles</th>
                                <th>Sites</th>
                                <th>Actions</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
