@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $user) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-8">
            @include('MGCms2019::admin.users.partials.profile')
        </div>
        <div class="col-md-4">
            <div class="text-right">
                @can('viewAny', AvengersMG\MGCms2019\App\Cms\Users\User::class)
                <a href="{{ route('users.index') }}" class="btn btn-primary">Regresar a usuarios</a>
                @endcan
            </div>
        </div>
        <div class="col-md-12">
              <div class="box-body">
                    <div class="row">
                        <div class="col-md-8">
                            @include('MGCms2019::admin.partials.formErrors')
                            {!! Form::model($user, ['route' => ['users.update', $user], 'method' => 'PUT']) !!}
                            <div class="row">

                                <input type="hidden" name="id" value="{{ $user->id }}">

                                <div class="form-group col-md-6">
                                    <label for="name">Name</label>
                                    {!! Form::text('name', old('name'), ['class' => 'form-control', 'placeholder' => 'Name']) !!}
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="username">Username</label>
                                    {!! Form::text('username', old('username'), ['class' => 'form-control', 'placeholder' => 'Username']) !!}
                                </div>
                                <div class="form-group col-md-12">
                                    <label for="email">Email address</label>
                                    {!! Form::text('email', old('email'), ['class' => 'form-control', 'placeholder' => 'example@emaple.com']) !!}
                                </div>

                                @can('updateOwnRole', $user)
                                <div class="form-group col-md-12">
                                    <label>Role</label>
                                    {!! Form::select('role', $roles->pluck('name', 'name'), $user->roles->first()->name, ['class' => 'form-control']) !!}
                                </div>
                                @endcan

                                @can('updateOwnSites', AvengersMG\MGCms2019\App\Cms\Users\User::class)
                                <div class="form-group col-md-12">
                                    <label for="">Sites</label>
                                    <div class="form-check">
                                        @foreach($sites as $site)
                                            <label class="form-check-label">
                                                <input class="form-check-inline" type="checkbox" name="sites[]" value="{{ $site->id }}" {{ (in_array($site->id, $user_sites)) ? 'checked' : '' }}>
                                                {{ $site->name }}
                                            </label>
                                        @endforeach
                                    </div>
                                </div>
                                @endcan

                                <div class="form-group col-md-6">
                                    <label for="password">Password</label>
                                    <input type="password" class="form-control" name="password" placeholder="Password">
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="password">Password</label>
                                    <input type="password" class="form-control" name="password_confirmation" placeholder="Confirm Password">
                                </div>

                            </div>
                            @can('update', $user)
                            <div class="box-footer text-right">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                            @endcan
                            {!! Form::close() !!}
                        </div>

                    </div>
                </div>
        </div>
    </div>
@endsection
