@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h3>Crear usuario</h3>
                    <div class="col-md-12 text-right">
                        @can('viewAny', AvengersMG\MGCms2019\App\Cms\Users\User::class)
                        <a href="{{ route('users.index') }}" class="btn btn-primary">Regresar a usuarios</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body">
                   <div class="row">
                       <div class="col-md-12">
                           @include('MGCms2019::admin.partials.formErrors')
                           {!! Form::open(['route' => 'users.store', 'method' => 'post']) !!}
                               <div class="row">
                                   <div class="form-group col-md-6">
                                       <label for="name">Name</label>
                                       <input type="text" class="form-control" value="{{ old('name') }}" id="name" name="name" placeholder="Name">
                                   </div>
                                   <div class="form-group col-md-6">
                                       <label for="username">Username</label>
                                       <input type="text" class="form-control" value="{{ old('username') }}" id="username" name="username" placeholder="Username">
                                   </div>
                                   <div class="form-group col-md-12">
                                       <label for="email">Email address</label>
                                       <input type="email" class="form-control" value="{{ old('email') }}" id="email" name="email" placeholder="Enter email">
                                   </div>

                                   <div class="form-group col-md-12">
                                       <label>Role</label>
                                       {!! Form::select('role', $roles->pluck('name', 'name'), '', ['class' => 'form-control']) !!}
                                   </div>

                                   <div class="form-group col-md-12">
                                       <label for="">Sites</label>
                                       <div class="form-check">
                                           @foreach($sites as $site)
                                           <label class="form-check-label">
                                               <input class="form-check-inline" type="checkbox" name="sites[]" value="{{ $site->id }}">
                                               {{ $site->name }}
                                           </label>
                                           @endforeach
                                       </div>
                                   </div>

                                   <div class="form-group col-md-6">
                                       <label for="password">Password</label>
                                       <input type="password" class="form-control" name="password" placeholder="Password">
                                   </div>

                                   <div class="form-group col-md-6">
                                       <label for="password">Password</label>
                                       <input type="password" class="form-control" name="password_confirmation" placeholder="Confirm Password">
                                   </div>

                               </div>
                               @can('create', AvengersMG\MGCms2019\App\Cms\Users\User::class)
                               <div class="box-footer text-right">
                                   <button type="submit" class="btn btn-primary">Submit</button>
                               </div>
                              @endcan
                           {!! Form::close() !!}
                       </div>
                   </div>
                </div>

            </div>
        </div>
    </div>
@endsection
