@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection
@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <div class="col-md-12 text-right">
                        @can('create', AvengersMG\MGCms2019\App\Cms\Socialmedias\Socialmedia::class)
                        <a href="{{ route('socialmedias.create') }}" class="btn btn-primary"><i class="fas fa-plus"></i> Crear Red Social</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body" id="usser-tables">
                  @include('MGCms2019::admin.partials.formErrors')
                  <div class="col-md-12">
                    <table class="table table-bordered table-striped generalTable username-table">
                        <thead>
                        <tr>
                            <th>#ID</th>
                            <th>Nombre</th>
                            <th>Explicaci&oacute;n</th>
                            <th>Creado en</th>
                            <th>Acciones</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($socialmedias as $socialmedia)
                            <tr>
                                <td>{{ $socialmedia->id }}</td>
                                <td>{{ $socialmedia->description }}</td>
                                <td>{{ $socialmedia->body }}</td>
                                <td>{{ $socialmedia->created_at }}</td>
                                <td>
                                    @can('update', $socialmedia)
                                    <a href="{{ route('socialmedias.edit', $socialmedia) }}" class="btn btn-success btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Editar"><i class="fa fa-edit"></i></a>
                                    @endcan
                                    @can('delete', $socialmedia)
                                    <a href="{{ route('socialmedias.destroy', $socialmedia) }}" class="btn btn-danger btn-xs tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Eliminar"><i class="far fa-trash-alt"></i></a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                        <tfoot>
                          <tr>
                              <th>#ID</th>
                              <th>Nombre</th>
                              <th>Explicaci&oacute;n</th>
                              <th>Creado en</th>
                              <th>Acciones</th>
                          </tr>
                        </tfoot>
                    </table>
                  </div>
                </div>
            </div>
        </div>
    </div>

@endsection
