@extends('MGCms2019::admin.layouts.admin')
@section('breadcrumbs')
<section class="content-header">
    <h1>Gorilla CMS </h1>
    {{ Breadcrumbs::render(Route::currentRouteName(), $socialmedia) }}
</section>
@endsection

@section('content')

<div class="row">
    <div class="col-md-12">
        <div class="box box-default">
            <div class="box-header with-border">
                <h3>Editar Red Social</h3>
                <div class="col-md-12 text-right">
                    @can('viewAny', AvengersMG\MGCms2019\App\Cms\Socialmedias\Socialmedia::class)
                    <a href="{{ route('socialmedias.index') }}" class="btn btn-primary">Regresar a Redes Sociales</a>
                    @endcan
                </div>
            </div>

            <div class="box-body">
                @include('MGCms2019::admin.partials.formErrors')
                {!! Form::model($socialmedia, ['route' => ['socialmedias.update', $socialmedia], 'method' => 'put']) !!}
                @include('MGCms2019::admin.socialmedias.partials.form')
                @can('update', $socialmedia)
                <div class="box-footer text-right">
                    <button type="submit" class="btn btn-info">Guardar</button>
                </div>
                @endcan
                {!! Form::close() !!}
            </div>

        </div>
    </div>
</div>
@endsection
