@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
            <h1>{{ $site->name }}</h1>
            {{ Breadcrumbs::render(Route::currentRouteName(), $site, $lang) }}
    </section>
@endsection

@section('content')
    @if($lang == 'en')
        <a href="{{ route('sites.show', [$site->id, 'es']) }}" class="page-actions label-info edit">
            <img src="{{ asset('cms/images/lang/mexico.png') }}" alt="" class="" />
            <i class="fas label-{{ $site->translate('es') }}"></i>
        </a>
    @else
        <a href="{{ route('sites.show', [$site->id, 'en']) }}" class="page-actions label-info edit">
            <img src="{{ asset('cms/images/lang/united-states-of-america.png') }}" alt="" class="" />
            <i class="fas label-{{ $site->translate('en') }}"></i>
        </a>
    @endif
    <div class="box box-default">
        <div class="row">
            <div class="col-md-6">
                <div class="section">
                    <div class="title">Configuraci&oacute;n</div>
                     <div class="row">
                         @include('MGCms2019::admin.sites.partials.settings')
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="row">
                    <div class="col-12">
                        <div class="section">
                            <div class="title">P&aacute;ginas</div>
                            <div class="row align-items-center">
                                <div class="col">
                                    <h6>P&aacute;ginas</h6>
                                </div>
                                <div class="col">
                                     <p>{{ $site->pages->count() }}</p>
                                </div>
                                <div class="col">
                                    <a href="{{ route('pages.index', $site) }}" class="btn btn-info see-pages"> Ver P&aacute;ginas <i class="fa fa-arrow-circle-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="section">
                            <div class="title">Redes Sociales</div>
                            <div class="row">
                                @include('MGCms2019::admin.sites.partials.socialmedias')
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="section">
                            <div class="title">SEO</div>
                            <div class="row">
                                @include('MGCms2019::admin.sites.partials.seo')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
