@php
    $user = Auth::user();
@endphp
{!! Form::model($site, ['route' => ['sites.update', $site], 'method' => 'PUT', 'files' => true, 'class' => 'settings-form' ]) !!}
<div class="col-md-8 text-center">
    <img src="{{ asset($site->logo) }}" class="img-fluid" alt="">
</div>
<div class="form-group col file-space">
    <div class="upload-btn-wrapper">
      <button class="btn"><i class="fas fa-file-upload"></i> <br />Click para subir archivo </button>
      <input type="file" class="file" name="logo" placeholder="Site name" />
    </div>
</div>
@if($user->can('updateDomain', AvengersMG\MGCms2019\App\Cms\Sites\Site::class) || $user->can('updateOwnDomain', $site))
<div class="form-group col">
    <label for="domain">Dominio del sitio</label>
    {!! Form::text('domain', old('domain'), ['class' => 'form-control']) !!}
</div>
@endif
<div class="form-group col">
    <label for="name">Nombre del sitio</label>
    <input type="text" class="form-control" name="name" value="{{ $site->name }}" placeholder="Site name" required>
</div>
<div class="form-group col">
    <label for="phone">Tel&eacute;fono ({{ app()->getLocale() }})</label>
    <input type="text" class="form-control" name="phone" value="{{ $site->phone }}" placeholder="Site Phone">
</div>
@can('update', $site)
<div class="col-md-12 text-left">
    <input name="lang" type="hidden" value="{{ $lang }}">
    <button type="submit" class="btn btn-info">Actualizar</button>
</div>
@endcan
{!! Form::close() !!}
