@extends('MGCms2019::admin.layouts.admin')
@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection
@section('content')
<div class="box box-default">
    <div class="box-header">
        <h3 class="box-title">Sites</h3>
        <div class="col-md-12 text-right">
            @can('create', AvengersMG\MGCms2019\App\Cms\Sites\Site::class)
            <a href="{{ route('sites.create') }}" class="btn btn-primary">Agregar nuevo sitio</a>
            @endcan
        </div>
    </div>
    <div class="box-body">
        @foreach($sites as $site)
        @can('view', $site)
        <div class="col-md-4">
            <div class="small-box bg-aqua">
                <div class="inner">
                    <h3>{{ ucwords($site->name) }}</h3>
                    <hr>
                    <p>Páginas: {{ $site->pages->count() }}</p>
                </div>
                <div class="icon">
                    <i class="fas fa-code"></i>
                </div>
                <div class="site-card-info">
                    <a href="http://{{ $site->domain }}" target="-_blank">Ver sitio <i class="fa fa-eye"></i></a>
                    @can('update', $site)
                    <a href="{{ route('sites.show', [$site, 'en']) }}"> Más info <i class="fa fa-arrow-circle-right"></i></a>
                    @endcan
                </div>
            </div>
        </div>
        @endcan
        @endforeach
    </div>
</div>
@endsection
