@extends('MGCms2019::admin.layouts.admin')


@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h3><i class="fas fa-laptop-code"></i> Nuevo sitio</h3>
                    <div class="col-md-12 text-right">
                        @can('viewAny', AvengersMG\MGCms2019\App\Cms\Sites\Site::class)
                        <a href="{{ route('sites.index') }}" class="btn btn-primary"><i class="fas fa-chevron-left"></i> Regresar a Sitios</a>
                        @endcan
                        @can('create', AvengersMG\MGCms2019\App\Cms\Sites\Site::class)
                        <button type="submit" class="btn purple">Crear <i class="fas fa-plus"></i></button>
                        @endcan
                    </div>
                </div>

                <div class="box-body">
                        @include('MGCms2019::admin.partials.formErrors')
                        {!! Form::open(['route' => 'sites.store', 'method' => 'post', 'class' => 'newsite', 'files' => true]) !!}
                        <div class="row">
                            <div class="col-md-6">
                                <label for="domain">Dominio del sitio</label>
                                <input type="text" class="form-control" name="domain" placeholder="example.com" required>
                            </div>
                            <div class="col-md-6">
                                <label for="name">Nombre del sitio</label>
                                <input type="text" class="form-control" name="name" placeholder="Site name" required>
                            </div>
                            <div class="col-md-6">
                                <label for="logo">Logo</label>
                                <input type="file" class="form-control" name="logo" placeholder="Site name">
                            </div>
                            <div class="col-md-6">
                                <label for="phone">Telefono</label>
                                <input type="number" class="form-control" name="phone" placeholder="Site Phone">
                            </div>
                            <div class="col-md-6">
                                <label for="meta_title">Meta title</label>
                                <input type="text" class="form-control" name="meta_title" placeholder="Meta title">
                            </div>
                            <div class="col-md-12">
                                <label for="formGroupExampleInput">Meta Descripcion</label>
                                <textarea class="form-control" name="meta_description" placeholder="Meta Description"></textarea>
                            </div>
                            <div class="col-md-12">
                                <label for="schema">Schemas</label>
                                <textarea class="form-control" name="schema"></textarea>
                            </div>
                            @can('create', AvengersMG\MGCms2019\App\Cms\Sites\Site::class)
                            <div class="col-md-12">
                                <button type="submit" class="btn purple">Crear <i class="fas fa-plus"></i></button>
                            </div>
                            @endcan
                            {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
