@extends('MGCms2019::admin.layouts.admin')

@section('content')
<!-- /.row -->
<div class="row container">
<div class="col-xs-12">
  <div class="box">
    <div class="box-header">
      <h3 class="box-title">Responsive Hover Table</h3>

      <div class="box-tools">
        <div class="input-group input-group-sm" style="width: 150px;">
          <input type="text" name="table_search" class="form-control pull-right" placeholder="Search">

          <div class="input-group-btn">
            <button type="submit" class="btn btn-default"><i class="fa fa-search"></i></button>
          </div>
        </div>
      </div>
    </div>
    <!-- /.box-header -->
    <div class="box-body table-responsive no-padding">
      <table class="table table-hover">
        <tr>
          <th>ID Folio</th>
          <th>Formulario salida</th>
          <th>Status</th>
          <th>assigned</th>
          <th>idioma</th>
          <th>Fecha de creación</th>
          <th>Editar</th>
          <th>Eliminar</th>
        </tr>
        @foreach($data as $dato)
        <tr>
          <td>{{ $dato->id }}</td>
          <td>{{ $dato->form_id }}</td>
          <td><span class="label label-warning">{{ ($dato->status == 0)? 'Pendiente' : 'Completado' }}</span></td>
          <td>{{ $dato->assigned }}</td>
          <td>{{ $dato->locale }}</td>
          <td>{{ $dato->created_at }}</td>
          <td>
              @can('update', $dato)
              <a href="{{ route('form-services.edit', $dato->id) }}" type="button" class="btn btn-block btn-primary">Editar</a>
              @endcan
          </td>
          <td>
              @can('delete', $dato)
              <a href="{{ route('form-services.destroy', $dato->id) }}" type="button" class="btn btn-block btn-danger">Eliminar</a>
              @endcan
          </td>
        </tr>
        @endforeach
      </table>
    </div>
    <!-- /.box-body -->
  </div>
  <!-- /.box -->
</div>
</div>


@stop
