@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <div class="row">
                        <div class="col-md-6">
                        <div class="alert alert-info">
                            <p>Las imágenes de los sitios de reviews deben estar en la carpeta <code>public/images/reviews</code></p>
                        </div>
                    </div>
                    <div class="col-md-6 text-right">
                        @can('create', AvengersMG\MGCms2019\App\Cms\Reviews\Review::class)
                        <a href="{{ route('reviews.create') }}" class="btn btn-primary">Agregar Comentario</a>
                        @endcan
                    </div>
                    </div>
                </div>

                <div class="box-body" id="usser-tables">

                    <div class="col-md-12">
                        <table class="table table-hover generalTable username-table">
                            <thead class="table-info">
                            <tr>
                                <th>#ID</th>
                                <th>Avatar</th>
                                <th>Nombre</th>
                                <th>Estrellas</th>
                                <th>Título</th>
                                <th>Lenguaje</th>
                                <th>Acciones</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($reviews as $review)
                                <tr>
                                    <td>{{ $review->id }}</td>
                                    <td>
                                        <img src="{{ asset($review->avatar) }}" alt="" style="width: 72px; height: 72px">
                                    </td>
                                    <td>{{ $review->name }}</td>
                                    <td>{{ $review->stars }}</td>
                                    <td>{{ $review->title }}</td>
                                    <td>{{ $review->locale }}</td>
                                    <td class="text-center">
                                        @can('update', $review)
                                        <a href="{{ route('reviews.edit', $review) }}" class="btn btn-success btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Editar"><i class="fa fa-edit"></i></a>
                                        @endcan
                                        @can('delete', $review)
                                        <a href="{{ route('reviews.destroy', $review) }}" class="btn btn-danger btn-xs tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Eliminar"><i class="fas fa-times"></i></a>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach

                            </tbody>
                            <tfoot class="table-info">
                            <tr>
                                <th>#ID</th>
                                <th>Avatar</th>
                                <th>Nombre</th>
                                <th>Estrellas</th>
                                <th>Título</th>
                                <th>Lenguaje</th>
                                <th>Acciones</th>
                            </tr>
                            </tfoot>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
