@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $review) }}
    </section>
@endsection

@section('content')

    <div class="col-md-12">
        <div class="box-header with-border">
            <h3>Editar Comentarios</h3>
        </div>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a href="#site-content" data-toggle="tab" aria-expanded="true" class="nav-link active">Comentarios</a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="site-content">
                    {!! Form::model($review, ['route' => ['reviews.update', $review], 'method' => 'put', 'files' => true]) !!}
                    <div class="box-body">
                        @include('MGCms2019::admin.partials.formErrors')
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="form-group col-md-4">
                                        <label>Lenguaje</label>
                                        {!! Form::select('locale', ['en' => 'en', 'es' =>'es'], old('locale'),
                                        ['class'  => 'form-control']) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-12">
                                <label>Avatar</label>
                                {!! Form::select('avatar', $images , old('avatar'), ['class' => 'form-control', 'required']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Nombre</label>
                                {!! Form::text('name', old('name'), ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Estrellas</label>
                                {!! Form::select('stars', ['1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5'], old('stars'),['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>URL</label>
                                {!! Form::text('link', old('url_custom'), ['class'  => 'form-control static-url']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Título</label>
                                {!! Form::text('title', old('title'), ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-12">
                                <label>Cuerpo</label>
                                {!! Form::textarea('body', old('body'), ['class'  => 'wysiwyg']) !!}
                            </div>
                            @can('update', $review)
                            <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-info">Editar</button>
                            </div>
                            @endcan
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>

@endsection
