@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')

    <div class="col-md-12">
        <div class="box-header with-border">
            <h3>Nuevo Comentario</h3>
        </div>
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a href="#site-content" data-toggle="tab" aria-expanded="true" class="nav-link active">Comentario</a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="site-content">
                    <div class="alert alert-info">
                        <p>Las imágenes de los sitios de comentarios deben estar en la carpeta <code>public/images/reviews</code></p>
                    </div>
                    {!! Form::open(['route' => ['reviews.store'], 'method' => 'post', 'files' => true]) !!}
                    <div class="box-body">
                        @include('MGCms2019::admin.partials.formErrors')
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="form-group col-md-4">
                                        <label>Lenguaje</label>
                                        {!! Form::select('locale', ['en' => 'en', 'es' =>'es'], 'en',
                                        ['class'  => 'form-control']) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-6">
                                <label>Avatar</label>
                                {!! Form::select('avatar', $images , '', ['class' => 'form-control', 'required']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Nombre</label>
                                {!! Form::text('name', old('name'), ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Estrellas</label>
                                {!! Form::select('stars', ['1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5'], 'bottom',['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>URL</label>
                                {!! Form::text('link', old('url_custom'), ['class'  => 'form-control static-url']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Título</label>
                                {!! Form::text('title', old('title'), ['class'  => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-12">
                                <label>Cuerpo</label>
                                {!! Form::textarea('body', old('body'), ['class'  => 'wysiwyg']) !!}
                            </div>
                            @can('create', AvengersMG\MGCms2019\App\Cms\Reviews\Review::class)
                            <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-info">Crear</button>
                            </div>
                            @endcan
                        </div>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>

@endsection
