@extends('MGCms2019::admin.layouts.admin')
@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $page, $lang) }}
    </section>
@endsection

@section('content')
    <div class="box box-default">
        <div class="nav-tabs-custom">
                <div class="text-right col-md-12">
                @if($page->isRoot())
                    <a href="{{ route('pages.show', [$page->id, ($lang == 'en') ? 'es' : 'en']) }}" class="btn btn-outline-info">
                        @if($lang == 'en')
                            <img src="{{ asset('cms/images/lang/mexico.png') }}" alt="" class="">
                        @else
                            <img src="{{ asset('cms/images/lang/united-states-of-america.png') }}" alt="" class="">
                        @endif
                    </a>
                    @else
                        @if($page->parent->translate($alter_lang))
                            <a href="{{ route('pages.show', [$page->id, ($lang == 'en') ? 'es' : 'en']) }}" class="btn btn-outline-info">
                                @if($lang == 'en')
                                    <img src="{{ asset('cms/images/lang/mexico.png') }}" alt="" class="">
                                @else
                                    <img src="{{ asset('cms/images/lang/united-states-of-america.png') }}" alt="" class="">
                                @endif
                            </a>
                        @endif
                @endif

                @can('update', $page)
                <a href="#!" class="btn btn btn-info" data-toggle="modal" data-target="#component">Agregar Componentes</a>
                @endcan
                <a href="http://{{ $page->site->domain }}{{ $page->perman_link }}" class="btn btn-primary" id="link-page" target="_blank"><i class="fa fa-eye"></i> P&aacute;gina</a>
                @can('update', $page)
                <a href="{{ route('pages.translations.destroy', [$page, $lang]) }}" class="btn btn-danger delete-model">
                    <i class="fas fa-trash-alt"></i>
                    Eliminar Traducci&oacute;n
                </a>
                @endcan
            </div>
            <br>
            <ul class="nav nav-tabs">
                <li class="nav-item">
                    <a href="#site-content" data-toggle="tab" aria-expanded="true" class="nav-link active">Información de la página</a>
                </li>
                <li class="nav-item">
                    <a href="#seo" data-toggle="tab" aria-expanded="false" class="nav-link">SEO</a>
                </li>
                <li class="nav-item">
                    <a href="#media" data-toggle="tab" aria-expanded="false" class="nav-link">Media</a>
                </li>
                <li class="nav-item">
                    <a href="#galleries" data-toggle="tab" aria-expanded="false" class="nav-link">Galerías</a>
                </li>
                <li class="nav-item">
                    <a href="#relations" data-toggle="tab" aria-expanded="false" class="nav-link">Relación</a>
                </li>
                <li class="nav-item">
                    <a href="#cards" data-toggle="tab" aria-expanded="false" class="nav-link">Postales</a>
                </li>
                @if($page->room)
                    <li class="nav-item">
                        <a href="#room" data-toggle="tab" aria-expanded="false" class="nav-link">Detalle de Habitaci&oacute;n</a>
                    </li>
                @endif
                @if($page->special)
                    <li class="nav-item">
                        <a href="#special" data-toggle="tab" aria-expanded="false" class="nav-link">Oferta</a>
                    </li>
                @endif
                @if($page->tour)
                    <li class="nav-item">
                        <a href="#tour" data-toggle="tab" aria-expanded="false" class="nav-link">Tour</a>
                    </li>
                @endif
                @if($page->restaurant)
                    <li class="nav-item">
                        <a href="#restaurant" data-toggle="tab" aria-expanded="false" class="nav-link">Restaurante</a>
                    </li>
                @endif
            </ul>
            <div class="tab-content page-content">
                <div class="tab-pane active" id="site-content">
                    <div class="row">
                        @include('MGCms2019::admin.pages.partials.generalInfo')
                    </div>
                </div>
                <div class="tab-pane" id="seo">
                    <div class="row">
                        @include('MGCms2019::admin.pages.partials.seo')
                    </div>
                </div>
                <div class="tab-pane" id="media">
                    <div class="row">
                        @include('MGCms2019::admin.pages.partials.media')
                    </div>
                </div>
                <div class="tab-pane" id="galleries">
                    <div class="row">
                        @include('MGCms2019::admin.pages.partials.galleries')
                    </div>
                </div>
                <div class="tab-pane" id="cards">
                    <div class="row">
                        @include('MGCms2019::admin.pages.partials.cards')
                    </div>
                </div>
                <div class="tab-pane" id="relations">
                    <div class="row">
                        @include('MGCms2019::admin.pages.partials.relations')
                    </div>
                </div>
                @if($page->room)
                    <div class="tab-pane" id="room">
                        <div class="row">
                            @include('MGCms2019::admin.pages.partials.room')
                        </div>
                    </div>
                @endif
                @if($page->special)
                    <div class="tab-pane" id="special">
                        <div class="row">
                            @include('MGCms2019::admin.pages.partials.special')
                        </div>
                    </div>
                @endif
                @if($page->tour)
                    <div class="tab-pane" id="tour">
                        <div class="row">
                            @include('MGCms2019::admin.pages.partials.tour')
                        </div>
                    </div>
                @endif



                @if($page->restaurant)
                    <div class="tab-pane" id="restaurant">
                        <div class="row">
                            @include('MGCms2019::admin.pages.partials.restaurant')
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    @can('update', $page)
    <!-- Modal -->
    <div class="modal fade" id="component" tabindex="-1" role="dialog" aria-labelledby="componentLabel">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="componentLabel">Componentes</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    @if(!$page->room)
                    <a href="{{ route('rooms.create', [$page, $lang]) }}" class="btn btn-primary btn-block">Agregar Habitaci&oacute;n</a>
                    @endif
                    @if(!$page->special)
                    <a href="{{ route('specials.create', [$page, $lang]) }}" class="btn btn-primary btn-block">Agregar Oferta</a>
                    @endif
                    @if(!$page->tour)
                    <a href="{{ route('tours.create', [$page, $lang]) }}" class="btn btn-primary btn-block">Agregar Tour</a>
                    @endif
                    @if(!$page->restaurant)
                    <a href="{{ route('restaurant.create', [$page, $lang]) }}" class="btn btn-primary btn-block">Agregar Restaurante</a>
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>
    @endcan

@endsection
