@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $page, app()->getLocale()) }}
    </section>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            {!! Form::open(['route' => 'relations.store', 'method' => 'post', 'class' => 'col-md-12']) !!}
            {!! Form::hidden('page_id', $page->id) !!}
            {!! Form::hidden('lang', $lang) !!}
            <div class="form-group col-md-6">
                <label>Nombre de la relaci&oacute;n</label>
                {!! Form::text('name', '', ['class' => 'form-control', 'required']) !!}
            </div>
            <div class="form-group col-md-6">
                <label>Relaci&oacute;n</label>
                {!! Form::select('related_page', $list_pages, '', ['class' => 'form-control']) !!}
            </div>
            @can('update', $page)
            <div class="form-group col-md-12 text-right">
                <button type="submit" class="btn btn-primary">Guardar</button>
            </div>
            @endcan
            {!! Form::close() !!}
        </div>
    </div>
@endsection
