<div class="col-md-12">
    {!! Form::model($page->tour, ['route' => ['tours.update', $page->tour->id], 'method' => 'PUT', 'class' => 'col-md-12']) !!}
        {!! Form::hidden('page_id', old('page_id')) !!}
            {!! Form::hidden('locale', $lang) !!}
            <div class="row">
                @can('update', $page)
                <div class="col-md-12 text-right">
                    <a href="{{ route('tours.destroy', [$page->tour, $lang]) }}" class="btn btn-danger delete-model">
                        <i class="fas fa-trash-alt"></i>
                    </a>
                </div>
                @endcan
                <div class="form-group col-md-12">
                    <label for="">Nombre</label>
                    {!! Form::text('name', $page->title ,['class' => 'form-control', 'readonly']) !!}
                </div>
                <div class="form-group col-md-6">
                    <label for="">Actividad</label>
                    {!! Form::text('activity', $page->tour->activity ,['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-6">
                    <label for="">Recomendaciones</label>
                    {!! Form::text('recommendations', $page->tour->recommendations ,['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-6">
                    <label for="">Restricci&oacute;n</label>
                    {!! Form::text('restriction', $page->tour->restriction ,['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-6">
                    <label for="">Duraci&oacute;n</label>
                    {!! Form::text('duration', $page->tour->duration, ['class' => 'form-control']) !!}
                </div>
                @can('update', $page)
                <div class="col-md-12 text-right">
                    <a href="javascript:void(0);" class="btn btn-info submit-using-ajax" data-on-action-success-message="Tour guardado">Guardar</a>
                    @can('viewAny', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $page->site])
                    <button type="submit" class="btn btn-info">Guardar y cerrar</button>
                    @endcan
                </div>
                @endcan
        </div>
    {!! Form::close() !!}
</div>
