<div class="col-md-12">

    {!! Form::model($special, ['route' => ['specials.update', $special->id], 'method' => 'PUT', 'class' => 'col-md-12']) !!}
    {!! Form::hidden('page_id', old('page_id')) !!}
    {!! Form::hidden('locale', $lang) !!}
    <div class="row">
        @can('update', $page)
        <div class="col-md-12 text-right">
            <a href="{{ route('specials.destroy', [$special, $lang]) }}" class="btn btn-danger delete-model">
                <i class="fas fa-trash-alt"></i>
            </a>
        </div>
        @endcan
        <div class="form-group col-md-4">
            <label for="">Nombre de especial</label>
            {!! Form::text('name', $page->name ,['class' => 'form-control', 'readonly']) !!}
        </div>
        <div class="form-group col-md-4">
            <label for="">Ventana de reservaci&oacute;n</label>
            {!! Form::text('booking_w', $special->booking_window ,['class' => 'form-control date-picker']) !!}
        </div>
        <div class="form-group col-md-4">
            <label for="">Ventana de viaje</label>
            {!! Form::text('travel_w', $special->travel_window ,['class' => 'form-control date-picker']) !!}
        </div>
        <div class="form-group col-md-4">
            <div class="custom-control custom-switch">
               {!! Form::checkbox('countdown', 1, ($special->countdown) ? true : false, ['id' => 'counterpromo', 'class' => 'custom-control-input']) !!}
              <label class="custom-control-label" for="counterpromo">Cuenta regresiva</label>
            </div>
        </div>
        <div class="form-group col-md-4">
            <div class="custom-control custom-switch">
               {!! Form::checkbox('permanent', 1, ($special->permanent) ? true : false, ['id' => 'permanentpromo', 'class' => 'custom-control-input']) !!}
              <label class="custom-control-label" for="permanentpromo">Promoci&oacute;n permanente</label>
            </div>
        </div>
        <div class='form-group col-sm-4'>
            <label for="">Fecha y hora para notificaciones</label>
            @if($special->hasTranslation($lang))
                @php
                    $notificationTime = optional($special->translate($lang)->notifications()->latest()->first())->notification_time
                @endphp
            @else
                @php
                    $notificationTime = Carbon\Carbon::now()->toDateTimeString();
                @endphp
            @endif
            {!! Form::text('notification_time', $notificationTime, ['class' => 'form-control']) !!}
        </div>
        <div class="form-group col-md-12">
            <h5>Call To Action</h5>
        </div>
        @php
            $call_to_action = json_decode($special->cta, true)
        @endphp
        <div class="form-group col-md-12">
            <div class="row callnumber">
                <div class="form-group col-md-3">
                    {!! Form::checkbox('bookingcta', 1, $call_to_action['bookingcta'], ['class' => 'bookingcta']) !!}
                    <label class="" for="bookingcta">Booking</label>
                </div>
                <div class="form-group col-md-3">
                    {!! Form::checkbox('llamadacta', 1, $call_to_action['callcta'], ['class' => 'llamadacta']) !!}
                    <label class="" for="llamadacta">Llamada</label>
                </div>
                <div class="form-group col-md-6">
                    {!! Form::checkbox('linkcta', 1, $call_to_action['linkcta'], ['class' => 'linkcta']) !!}
                    <label class="" for="linkcta">Custom</label>
                </div>
                @isset($call_to_action[0]['tel'])
                <div class="row" id="tel-remove">
                    <div class="form-group col-md-4"><img src="/cms/images/lang/united-states-of-america.png" alt="EN"> TEL_EN
                        {!! Form::text('numbertel', $call_to_action[0]['tel'] ,['class' => '']) !!}
                    </div>
                    <div class="form-group col-md-4"><img src="/cms/images/lang/mexico.png" alt="ES"> TEL_ES
                        {!! Form::text('numbertel_es', $call_to_action[0]['tel_es'] ,['class' => '']) !!}
                    </div>
                </div>
                @endisset
                @isset($call_to_action[1]['link'])
                <div class="row" id="name-remove">
                    <div class="form-group col-md-2"><img src="/cms/images/lang/united-states-of-america.png" alt="EN"> CTA_EN
                        {!! Form::text('namecta', $call_to_action[1]['namecta'] ,['class' => '']) !!}
                    </div>
                    <div class="form-group col-md-2"><img src="/cms/images/lang/united-states-of-america.png" alt="EN"> LINK_EN
                        {!! Form::text('link', $call_to_action[1]['link'] ,['class' => '']) !!}
                    </div>
                    <div class="form-group col-md-2"><img src="/cms/images/lang/mexico.png" alt="ES"> CTA_ES
                        {!! Form::text('namecta_es', $call_to_action[1]['namecta_es'] ,['class' => '']) !!}
                    </div>
                    <div class="form-group col-md-2"><img src="/cms/images/lang/mexico.png" alt="ES"> LINK_ES
                        {!! Form::text('link_es', $call_to_action[1]['link_es'] ,['class' => '']) !!}
                    </div>
                </div>
                @endisset
            </div>
        </div>
        <div class="form-group col-md-12">
            <label for="">T&eacute;rminos y condiciones</label>
            {!! Form::textarea('terms', old('terms'), ['class' => 'form-control wysiwyg']) !!}
        </div>
    </div>
    @can('update', $page)
    <div class="col-md-12 text-right">
        <a href="javascript:void(0);" class="btn btn-info submit-using-ajax" data-on-action-success-message="Especial guardado">Guardar</a>
        @can('viewAny', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $page->site])
        <button type="submit" class="btn btn-info">Guardar y cerrar</button>
        @endcan
    </div>
    @endcan
    {!! Form::close() !!}
</div>
