@php
    /** @var boolean Presencia de códigos de API */
    if ($apiCodesExist = $room->apiCodes()->exists()) {
        /*
            Solo cargar si existen.

            NOTA: "apiCodes.translation" solo carga la traducción del idioma activo
        */
        $room->load(['apiCodes.translation.overrides']);
    }

    /** @var string Prefijo para los campos relacionados con el código de API. Para mantener DRY */
    $fieldPrefix = AvengersMG\MGCms2019\App\Cms\Accommodations\RoomApiCode::fieldPrefix() . '_';

    /** @var string Prefijo para los campos no existentes relacionados con el código de API. Para mantener DRY */
    $fieldTempPrefix = "timestamp_";

    
@endphp
<div class="col-md-12">
    @include('MGCms2019::admin.partials.formErrors')
    {!! Form::model($page->room, ['route' => ['rooms.update', $room->id], 'method' => 'PUT', 'class' => 'col-md-12 room-form', 'files' => true, 'id' => 'room-update-form']) !!}
    {!! Form::hidden('page_id', $room->page_id) !!}
    {!! Form::hidden('locale', $lang) !!}
    <div class="row">
        @can('update', $page)
        <div class="col-md-12 text-right">
            <a href="{{ route('rooms.destroy', [$page->room, $lang]) }}" class="btn btn-danger delete-model">
                <i class="fas fa-trash-alt"></i>
            </a>
        </div>
        @endcan
        <div class="col-md-4">
            <div class="form-group">
                <label for="">Nombre</label>
                <div class="input-group">
                    {!! Form::text('name', $page->name, ['class' => 'form-control']) !!}
                    <div class="input-group-append">
                        <button type="button" class="btn btn-outline-secondary" data-toggle="collapse" data-target="#room-api-code-override-name">Editar alias</button>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-name" data-room-api-code-field-type="text" data-room-api-code-field-attributes='{"class": "form-control", "placeholder": "(Vac&iacute;o)"}' data-room-api-code-field-name="name">@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_overrides = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->overrides : collect();
                        @endphp
                        <div class="room-api-code-override input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="input-group-prepend">
                                <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                            </div>
                            {!! Form::text("overrides[{$fieldPrefix}{$room_api_code->id}][name]", optional($room_api_code_translation_overrides->firstWhere("name", "name"))->data, ['class' => 'form-control', 'placeholder' => '(Vac&iacute;o)']) !!}
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label for="">C&oacute;digos de API</label>
                <div class="room-api-codes">
                    <div class="mb-3">
                        <button class="btn btn-outline-secondary btn-block room-api-codes-add" type="button">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                    <div class="room-api-codes-definitions">@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        <div class="room-api-code input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            {!! Form::text("api_id[{$fieldPrefix}{$room_api_code->id}]", $room_api_code->api_code, ['class' => 'form-control']) !!}
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary room-api-codes-remove" type="button">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        @endforeach
                    @endif</div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                @php
                    $categories_data = $categories->pluck('category', 'id');
                @endphp
                <label>Categor&iacute;a:</label>
                <div class="input-group">
                    {!! Form::select('category_id', $categories_data, $room->category_id, ['class' => 'custom-select form-control', "placeholder" => "(Vac&iacute;o)"]) !!}
                    <div class="input-group-append">
                        <button type="button" class="btn btn-outline-secondary" data-toggle="collapse" data-target="#room-api-code-override-category_id">Editar alias</button>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-category_id" data-room-api-code-field-type="select" data-room-api-code-field-attributes='{"class": "custom-select form-control"}' data-room-api-code-field-name="category_id" data-room-api-code-field-options='@json($categories_data, JSON_FORCE_OBJECT)'>@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_overrides = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->overrides : collect();
                        @endphp
                        <div class="room-api-code-override input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="input-group-prepend">
                                <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                            </div>
                            {!! Form::select("overrides[{$fieldPrefix}{$room_api_code->id}][category_id]", $categories_data, optional($room_api_code_translation_overrides->firstWhere("name", "category_id"))->data, ['class' => 'custom-select form-control', "placeholder" => "(Vac&iacute;o)"]) !!}
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label>Capacidad</label>
                <div class="input-group">
                    {!! Form::text('capacity_room', $room->capacity, ['class' => 'form-control', 'required']) !!}
                    <div class="input-group-append">
                        <button type="button" class="btn btn-outline-secondary" data-toggle="collapse" data-target="#room-api-code-override-capacity_room">Editar alias</button>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-capacity_room" data-room-api-code-field-type="text" data-room-api-code-field-name="capacity_room" data-room-api-code-field-attributes='{"class": "form-control", "placeholder": "(Vac&iacute;o)"}'>@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_overrides = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->overrides : collect();
                        @endphp
                        <div class="room-api-code-override input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="input-group-prepend">
                                <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                            </div>
                            {!! Form::text("overrides[{$fieldPrefix}{$room_api_code->id}][capacity_room]", optional($room_api_code_translation_overrides->firstWhere("name", "capacity_room"))->data, ['class' => 'form-control', 'placeholder' => '(Vac&iacute;o)']) !!}
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label>Adultos</label>
                <div class="input-group">
                    {!! Form::text('adults_room', $room->adults, ['class' => 'form-control', 'required']) !!}
                    <div class="input-group-append">
                        <button type="button" class="btn btn-outline-secondary" data-toggle="collapse" data-target="#room-api-code-override-adults_room">Editar alias</button>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-adults_room" data-room-api-code-field-type="text" data-room-api-code-field-name="adults_room" data-room-api-code-field-attributes='{"class": "form-control", "placeholder": "(Vac&iacute;o)"}'>@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_overrides = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->overrides : collect();
                        @endphp
                        <div class="room-api-code-override input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="input-group-prepend">
                                <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                            </div>
                            {!! Form::text("overrides[{$fieldPrefix}{$room_api_code->id}][adults_room]", optional($room_api_code_translation_overrides->firstWhere("name", "adults_room"))->data, ['class' => 'form-control', 'placeholder' => '(Vac&iacute;o)']) !!}
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label>Ni&ntilde;os</label>
                <div class="input-group">
                    {!! Form::text('childrens_room', $room->childrens, ['class' => 'form-control', 'required']) !!}
                    <div class="input-group-append">
                        <button type="button" class="btn btn-outline-secondary" data-toggle="collapse" data-target="#room-api-code-override-childrens_room">Editar alias</button>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-childrens_room" data-room-api-code-field-type="text" data-room-api-code-field-name="childrens_room" data-room-api-code-field-attributes='{"class": "form-control", "placeholder": "(Vac&iacute;o)"}'>@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_overrides = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->overrides : collect();
                        @endphp
                        <div class="room-api-code-override input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="input-group-prepend">
                                <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                            </div>
                            {!! Form::text("overrides[{$fieldPrefix}{$room_api_code->id}][childrens_room]", optional($room_api_code_translation_overrides->firstWhere("name", "childrens_room"))->data, ['class' => 'form-control', 'placeholder' => '(Vac&iacute;o)']) !!}
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <span class="badge badge-info">Ocupaci&oacute;n permitida</span>
                <div class="text-right">
                    <button type="button" class="btn btn-info" id="add-capacity">+ Agregar capacidades</button>
                </div>
            </div>
        </div>
       <div class="col-md-12">
            <div class="capacities row">
            @if($room->capacities)
            <h1>Json decode</h1>
            {{ $room->capacities }}
                @foreach(json_decode($room->capacities, true) as $key => $cap)
                        <div class="form-group col-md-2">
                            <label>Capacidad<span class="badge badge-info">{{ $key+1 }}</span></label>
                            {!! Form::text('capacity[]', $cap['capacidad'], ['class' => 'form-control', 'required']) !!}
                        </div>
                        <div class="row col-md-5">
                            <h3>S&iacute;:</h3>
                            <div class="form-group col-md-4">
                                <label>Adultos</label>
                                {!! Form::text('adults[]', $cap['yes']['adultos'], ['class' => 'form-control', 'required']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Ni&ntilde;os</label>
                                {!! Form::text('childrens[]', $cap['yes']['ninos'], ['class' => 'form-control', 'required']) !!}
                            </div>
                        </div>
                        <div class="row col-md-5">
                            <h3>No:</h3>
                            <div class="form-group col-md-4">
                                <label>Adultos</label>
                                {!! Form::text('adults_n[]', $cap['no']['adultos'], ['class' => 'form-control', 'required']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label>Ni&ntilde;os</label>
                                {!! Form::text('childrens_n[]', $cap['no']['ninos'], ['class' => 'form-control', 'required']) !!}
                            </div>
                        </div>
                @endforeach
            @endif
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label for="">Camas</label>
                <div class="input-group">
                    {!! Form::text('beds', old('beds'), ['class' => 'form-control']) !!}
                    <div class="input-group-append">
                        <button type="button" class="btn btn-outline-secondary" data-toggle="collapse" data-target="#room-api-code-override-beds">Editar alias</button>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-beds" data-room-api-code-field-type="text" data-room-api-code-field-name="beds" data-room-api-code-field-attributes='{"class": "form-control", "placeholder": "(Vac&iacute;o)"}'>@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_overrides = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->overrides : collect();
                        @endphp
                        <div class="room-api-code-override input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="input-group-prepend">
                                <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                            </div>
                            {!! Form::text("overrides[{$fieldPrefix}{$room_api_code->id}][beds]", optional($room_api_code_translation_overrides->firstWhere("name", "beds"))->data, ['class' => 'form-control', 'placeholder' => '(Vac&iacute;o)']) !!}
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label for="">Ba&ntilde;os</label>
                <div class="input-group">
                    {!! Form::text('bathrooms', old('bathrooms'), ['class' => 'form-control']) !!}
                    <div class="input-group-append">
                        <button type="button" class="btn btn-outline-secondary" data-toggle="collapse" data-target="#room-api-code-override-bathrooms">Editar alias</button>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-bathrooms" data-room-api-code-field-type="text" data-room-api-code-field-name="bathrooms" data-room-api-code-field-attributes='{"class": "form-control", "placeholder": "(Vac&iacute;o)"}'>@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_overrides = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->overrides : collect();
                        @endphp
                        <div class="room-api-code-override input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="input-group-prepend">
                                <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                            </div>
                            {!! Form::text("overrides[{$fieldPrefix}{$room_api_code->id}][bathrooms]", optional($room_api_code_translation_overrides->firstWhere("name", "bathrooms"))->data, ['class' => 'form-control', 'placeholder' => '(Vac&iacute;o)']) !!}
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="form-group">
                <label for="">&Aacute;rea de piso</label>
                <div class="input-group">
                    {!! Form::text('floor_area', old('floor_area'), ['class' => 'form-control']) !!}
                    <div class="input-group-append">
                        <button type="button" class="btn btn-outline-secondary" data-toggle="collapse" data-target="#room-api-code-override-floor_area">Editar alias</button>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-floor_area" data-room-api-code-field-type="text" data-room-api-code-field-name="floor_area" data-room-api-code-field-attributes='{"class": "form-control", "placeholder": "(Vac&iacute;o)"}'>@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_overrides = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->overrides : collect();
                        @endphp
                        <div class="room-api-code-override input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="input-group-prepend">
                                <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                            </div>
                            {!! Form::text("overrides[{$fieldPrefix}{$room_api_code->id}][floor_area]", optional($room_api_code_translation_overrides->firstWhere("name", "floor_area"))->data, ['class' => 'form-control', 'placeholder' => '(Vac&iacute;o)']) !!}
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
        <div class="col-md-12">
            <h3>Mapa 3D</h3>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <div class="input-group">
                    {!! Form::textarea('mapa', $room->map_3d, ['class' => 'form-control', 'rows' => 3]) !!}
                    <div class="input-group-append">
                        <button type="button" class="btn btn-outline-secondary" data-toggle="collapse" data-target="#room-api-code-override-mapa">Editar alias</button>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-mapa" data-room-api-code-field-type="textarea" data-room-api-code-field-name="mapa" data-room-api-code-field-attributes='{"class": "form-control", "placeholder": "(Vac&iacute;o)", "rows": 3}'>@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_overrides = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->overrides : collect();
                        @endphp
                        <div class="room-api-code-override input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="input-group-prepend">
                                <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                            </div>
                            {!! Form::textarea("overrides[{$fieldPrefix}{$room_api_code->id}][mapa]", optional($room_api_code_translation_overrides->firstWhere("name", "mapa"))->data, ['class' => 'form-control', 'placeholder' => '(Vac&iacute;o)', 'rows' => 3]) !!}
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
        <div class="col-md-12">
            <h3>Amenidades</h3>
        </div>
        <div class="form-group col-md-12">
            <ul class="amenities-list">
                @foreach($amenities as $amenity)
                    <li>
                        <label for="">{!! Form::checkbox('amenity[]', $amenity->id, ($room_amenities->contains($amenity->id)? 'checked' : '')) !!} {{ $amenity->name }}</label>
                    </li>
                @endforeach
            </ul>
        </div>
        <div class="col-md-12">
            <h3>Plano de piso</h3>
        </div>
        <div class="col-md-12">
            <div class="form-group">
                <div class="d-block">
                    <div class="input-group">
                        <div class="custom-file">
                            {!! Form::file('floor_plan', ['class' => 'custom-file-input', 'lang' => 'es']) !!}
                            <label class="custom-file-label">Subir archivo</label>
                        </div>
                        <div class="input-group-append">
                            <button type="button" class="btn btn-outline-secondary" data-toggle="collapse" data-target="#room-api-code-override-floor_plan">Editar alias</button>
                        </div>
                    </div>
                </div>
                @if(!empty($room->floor_plan))
                <div class="d-block pt-3">
                    <img src="/{{ $room->floor_plan }}" alt="" class="img-thumbnail" style="width: 250px" />
                </div>
                @endif
            </div>
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-floor_plan" data-room-api-code-field-type="file" data-room-api-code-field-name="floor_plan" data-room-api-code-field-attributes='{"class": "custom-file-input"}'>@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_overrides = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->overrides : collect();
                        @endphp
                        <div class="room-api-code-override mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="d-block">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                                    </div>
                                    <div class="custom-file">
                                        {!! Form::file("overrides[{$fieldPrefix}{$room_api_code->id}][floor_plan]", ['class' => 'custom-file-input', 'lang' => 'es']) !!}
                                        <label class="custom-file-label">Subir archivo</label>
                                    </div>
                                </div>
                            </div>
                            @php
                                $floor_plan_override_url = optional($room_api_code_translation_overrides->firstWhere("name", "floor_plan"))->data;
                            @endphp
                            @if(!is_null($floor_plan_override_url))
                            <div class="d-block pt-3">
                                <img src="/{{ $floor_plan_override_url }}" alt="" class="img-thumbnail" style="width: 250px" />
                            </div>
                            @endif
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
        <div class="col-md-3">
            <h3 class="float-left">Alias de <em>thumbnail</em></h3>
            <button type="button" class="btn btn-outline-secondary float-right" data-toggle="collapse" data-target="#room-api-code-override-thumbnail_mediafile_id">Editar</button>
        </div>
        <div class="col-md-12">
            @php
                $mediafiles_data = $page->mediafiles->mapWithKeys(function ($value) {
                    return ["{$value->id}" => $value->path,];
                });

                $mediafiles_data_options_attributes = $mediafiles_data->map(function ($value) {
                    return [
                        "data-img-src" => $value,
                    ];
                });
            @endphp
            <div class="form-group">
                <div class="room-api-code-overrides collapse" id="room-api-code-override-thumbnail_mediafile_id" data-room-api-code-field-type="image-picker" data-room-api-code-field-attributes='{"class": "image-picker masonry custom-select form-control"}' data-room-api-code-field-name="translation:thumbnail_mediafile_id" data-room-api-code-field-options='@json($mediafiles_data, JSON_FORCE_OBJECT)'>@if($apiCodesExist)
                        @foreach($room->apiCodes as $room_api_code)
                        @php
                            $room_api_code_translation_thumbnail = ($room_api_code->hasTranslation($lang))? $room_api_code->translation->thumbnail_mediafile_id : "";
                        @endphp
                        <div class="room-api-code-override input-group mb-3" data-room-api-code-id="{{ $room_api_code->id }}">
                            <div class="input-group-prepend">
                                <span class="input-group-text">{{ $room_api_code->api_code }}</span>
                            </div>
                            {!! Form::select("overrides[{$fieldPrefix}{$room_api_code->id}][translation][thumbnail_mediafile_id]", $mediafiles_data, $room_api_code_translation_thumbnail, ['class' => 'image-picker masonry custom-select form-control', "placeholder" => "(Vac&iacute;o)"], $mediafiles_data_options_attributes->toArray()) !!}
                        </div>
                        @endforeach
                    @endif</div>
            </div>
        </div>
    </div>
    @can('update', $page)
    <div class="col-md-12 text-right">
        <a href="javascript:void(0);" class="btn btn-info submit-using-ajax" data-on-action-success-message="Habitación guardada">Guardar</a>
        @can('viewAny', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $page->site])
        <button type="submit" class="btn btn-info">Guardar y cerrar</button>
        @endcan
    </div>
    @endcan
    {!! Form::close() !!}
</div>
@push('scripts')
<script type="text/javascript">
    $(document).ready(function () {
        $('#room-api-code-override-thumbnail_mediafile_id').on('shown.bs.collapse', function () {
            /* Registrar una vez más el tamaño */
            $('ul.thumbnails.image_picker_selector').masonry('layout');
        });

        $('#room-update-form').on('on-action-success', function (e, data) {
            var dynamic_api_codes = $('.room-api-codes-definitions [name^="api_id\[{{ $fieldTempPrefix }}"]'),
                code_input,
                dynamic_name,
                definitive_name;
            
            if (typeof data.api_codes == "object" && Array.isArray(data.api_codes) && data.api_codes.length > 0) {
                for (var i = 0; i < data.api_codes.length; i++) {
                    code_input = dynamic_api_codes.filter(function (index, element) {
                        return $(element).val() == data.api_codes[i].api_code;
                    });

                    /* Si fue encontrado el campo, obtener el nombre y cambiarlos en todos */
                    if (code_input.length > 0) {
                        /* Construir nombre definitivo */
                        definitive_name = `{{ $fieldPrefix }}${data.api_codes[i].id}`;

                        dynamic_name = code_input.attr("name");
                        
                        /* Cortar las partes innecesarias */
                        dynamic_name = dynamic_name.substring(
                            (dynamic_name.indexOf('[') + 1),
                            dynamic_name.indexOf(']')
                        );

                        /* Cambiar el nombre del campo y el atributo de ID del padre con el código */
                        code_input.attr('name', `api_id[${definitive_name}]`);
                        code_input.parents('.room-api-code').attr('data-room-api-code-id', data.api_codes[i].id);

                        /* Cambiar el nombre de los campos de sobrescrituras */
                        $('.room-api-code-override [name^="overrides\[' + dynamic_name +'\]"]').each(function () {
                            var self = $(this)
                                container = self.parents('.room-api-code-overrides'),
                                inputGroup = self.parents('.room-api-code-override'),
                                field_name = container.data('room-api-code-field-name');
                            
                            /* Actualizar identidades */
                            inputGroup.attr('data-room-api-code-id', data.api_codes[i].id);
                            self.attr('name', `overrides[${definitive_name}][${field_name}]`);
                        });
                    }
                }
            }
        });
    });
</script>
@endpush