<div class="col-md-12">
    <div class="box box-default">
        <div class="box-header with-border">
            <h3>Editar Restaurante</h3>
        </div>
        <div class="box-body">
        @include('MGCms2019::admin.partials.formErrors')
        {!! Form::model($page->restaurant, ['route' => ['restaurants.update', $page->restaurant->id],'method' => 'PUT', 'files' => true]) !!}
        {!! Form::hidden('page_id', old($page->id)) !!}
        {!! Form::hidden('locale', $lang) !!}
            <div class="row">
                @can('update', $page)
                <div class="col-md-12 text-right">
                    <a href="{{ route('restaurants.destroy', [$page->restaurant, $lang]) }}" class="btn btn-danger delete-model">
                        <i class="fas fa-trash-alt"></i>
                    </a>
                </div>
                @endcan
                <div class="form-group col-md-4">
                    <label for="">Nombre</label> {!! Form::text('name', $page->name ,['class' => 'form-control', 'readonly'])!!}
                </div>
                <div class="form-group col-md-4">
                    <label for="">T&iacute;tulo</label> {!! Form::text('title', old('title'),['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-4">
                    <label for="">Subt&iacute;tulo</label> {!! Form::text('subtitle', old('subtitle'),['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-12 text-right">
                    <button type="button" class="btn btn-warning" id="add-horarios">+ Agregar horarios</button>
                </div>
                <div class="col-md-12">
                    <div class="horarios row">
                    @if($page->restaurant->open_hours)
                        @foreach(json_decode($page->restaurant->open_hours, true) as $key => $serv_hora)
                            <div class="form-group col-md-3">
                                <label for="">Servicio EN</label>
                                {!! Form::text('servicio[]', $serv_hora['servicio'] ,['class' => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-3">
                                <label for="">Servicio ES</label>
                                {!! Form::text('servicio_es[]',  array_key_exists('servicio_es', $serv_hora) ? $serv_hora['servicio_es'] : '' ,['class' => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-3">
                                <label>Abre</label>
                                {!! Form::time('open[]', $serv_hora['open'], ['class' => 'form-control', 'required']) !!}
                            </div>
                            <div class="form-group col-md-3">
                                <label>Cierra</label>
                                {!! Form::time('close[]', $serv_hora['close'], ['class' => 'form-control', 'required']) !!}
                            </div>
                        @endforeach
                    @endif
                    </div>
                </div>
                <div class="col-md-12">
                    <h3>Servicios</h3>
                </div>
                <div class="form-group col-md-12">
                    <ul class="amenities-list col-md-12">
                        @foreach ($services as $service)
                            <li>
                                <label for="">{!! Form::checkbox('services[]', $service->id) !!} {{ $service->name }}</label>
                            </li>
                        @endforeach
                    </ul>
                </div>
                <div class="form-group col-md-12 rest-add" id="menus">
                    <div class="text-right">
                        @can('update', $page)
                            <button type="button" class="btn btn-warning btn-xs" id="add-menus">
                                <i class="fa fa-plus"></i> Agregar nuevo men&uacute;
                            </button><br /><br />
                        @endcan
                    </div>
                    @if ($page->restaurant['menus'])
                        @foreach ($page->restaurant['menus'] as $key => $menu )
                            <div class="form-group rest-wrapp row" id="menus">
                                @can('update', $page)
                                <div class="col-1">
                                    <button class="delete-img-rest" type="button" data-route="{{ route('restaurants.show', [$page->restaurant->id, $key, $lang]) }}"><i class="fa fa-trash"></i></button>
                                </div>
                                @endcan
                                <div class="col-11">
                                    <input id="amenity-icon" type="text" class="form-control" name="menus[{{$key}}][0]" value="{{$menu['name']}}">
                                </div>
                                <div class="col-12">
                                    <input type="hidden" class="form-control" name="menus[{{$key}}][1]" value="{{$menu['path']}}">
                                    {!! Form::file('menus[]', ['id' => 'amenity-image']) !!}
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>
                <div class="form-group col-md-12">
                    <label for="">Contenido</label> {!! Form::textarea('body', old('body'),['class' => 'form-control wysiwyg']) !!}
                </div>
                @can('update', $page)
                <div class="col-md-12 text-right">
                    <a href="javascript:void(0);" class="btn btn-info submit-using-ajax" data-on-action-success-message="Restaurante guardado">Guardar</a>
                    @can('viewAny', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $page->site])
                    <button type="submit" class="btn btn-info">Guardar y cerrar</button>
                    @endcan
                </div>
                @endcan
            </div>
            {!! Form::close() !!}
        </div>
    </div>
</div>
