<div class="col-md-12 text-right">
    @can('update', $page)
    <a href="{{ route('relations.create', [$page, $lang]) }}" class="btn btn-warning"> + Add Relation</a>
    @endcan
</div>
<div class="col-md-12">
@foreach($page->pageRelations as $relation)
    {!! Form::open(['route' => ['relations.update', $relation], 'method' => 'put']) !!}
    {!! Form::hidden('page_id', $relation->page_id) !!}
    {!! Form::hidden('lang', $lang) !!}
    <div class="form-group">
        <hr>
        <div class="row">
            <div class="form-group col-md-6">
                <label>Nombre de la relaci&oacute;n</label>
                {!! Form::text('name', $relation->name, ['class' => 'form-control', 'required']) !!}
            </div>
            <div class="form-group col-md-6">
                <label>Relaci&oacute;n</label>
                {!! Form::select('related_page', $list_pages, $relation->related_page, ['class' => 'form-control']) !!}
            </div>
            <div class="form-group col-md-12 text-right">
                @can('update', $page)
                <a href="{{ route('relations.destroy', $relation) }}" class="btn btn-danger delete-model"> <i class="fa fa-trash"></i> Eliminar relaci&oacute;n</a>
                <a href="javascript:void(0);" class="btn btn-info submit-using-ajax" data-on-action-success-message="Relación actualizada">Actualizar</a>
                    @can('viewAny', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $page->site])
                      <button type="submit" class="btn btn-primary">Actualizar y cerrar</button>
                    @endcan
                @endcan
            </div>
        </div>
    </div>
    {!! Form::close() !!}
@endforeach
</div>
