@php
    $user = Auth::user();
    $can_update_page = $user->can('update', $page);
    $can_view_mediafile = $user->can('viewFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $page->site]);
    $can_create_mediafile = $user->can('create', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $page->site]);
    $can_update_mediafile = $user->can('updateFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $page->site]);
    $can_delete_mediafile = $user->can('deleteFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $page->site]);
@endphp
@if($can_update_page && $can_create_mediafile)
<div class="col-md-12">
  {!! Form::open(['route' => 'page.upload.file', 'method' => 'POST', 'files'=> true, 'class' => 'dropzone', 'id' => 'dropzone']) !!}
  <input type="hidden" name="page" id="page" value="{{$page->id}}">
  <input type="hidden" name="lang" id="lang" value="{{ $lang }}">
  <div class="fallback">
      <input name="file" type="file" multiple/>¡¡
  </div>
  {!! Form::close() !!}
</div>
@endif
<div class="col-md-12 row" id="zone-content">
    @if($can_update_page && $can_view_mediafile)
    <div class="col-md-12" id="pagemedia">
        <div class="row page-media-container">
            @foreach($page->mediafiles as $key => $file)
                @php
                  $fileLangs = $file->translations->pluck('locale');
                  $fileLang = ($fileLangs->contains($lang))
                      ? $lang
                      : $fileLangs->first();
                @endphp
                <div class="col-md-3">
                    <div class="media-item media-item-{{ $file->id }} " data-toggle="modal" data-target="#file-detail-modal"
                         data-id="{{ $file->id }}"
                         data-route="{{ route('page.get.file', $file) }}"
                         data-delete="{{ route('mediafiles.destroy', $file) }}"
                         data-update="{{ route('files.update') }}"
                         data-path="{{ asset($file->path) }}"
                         data-type="{{ ($file->type) ? $file->type->id : ''}}"
                         data-lang="{{ $fileLang }}"
                         data-lang-delete-routes='@json(
                             collect(
                                 app()->make('translatable.locales')->all()
                             )->mapWithKeys(function($locale) use ($file){
                                 return ["{$locale}" => route('mediafiles.translations.destroy', [$file, $locale])];
                             })->all(),
                             JSON_UNESCAPED_SLASHES
                         )'
                        >
                        <div class="file-image" style="background-image: url('{{ asset($file->path) }}')">
                        </div>
                        @if($file->type)
                            <p class="file-type type-{{ $file->type->type }}">{{ $file->type->type }}</p>
                        @endif
                        <p class="file-image-languages text-center">{{ $fileLangs->implode(', ') }}</p>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
    @endif
</div>

<!-- Modal -->
@include('MGCms2019::admin.pages.partials.mediaModal')
