<div class="col-md-12">
    @include('MGCms2019::admin.partials.formErrors')
    {!! Form::model($page, ['route' => ['pages.update', $page->id ], 'method' => 'PUT', 'class' => 'col-md-12 page-form', 'id' => 'main-form-page']) !!}
    <input type="hidden" class="" name="site_id" value="{{ $page->site_id }}">
    <input type="hidden" value="{{ $lang }}" name="locale">
    <div class="row">
        <div class="col-md-12 align-self-end text-end">
            @can('update', $page)
                <a href="javascript:void(0);" class="btn btn-info submit-using-ajax" data-on-action-success-message="Página guardada">Guardar</a>
                    @can('viewAny', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $page->site])
                    <button type="submit" class="btn btn-info">
                        Guardar y cerrar
                    </button>
                    @endcan
            @endcan
        </div>
        <div class="col-md-8">
            <div class="row">
                <div class="form-group col-md-12">
                    <label for="name">Nombre de la p&aacute;gina</label>
                    {!! Form::text('name', old('name'), ['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-12">
                    <label for="title">T&iacute;tulo de la p&aacute;gina</label>
                    {!! Form::text('title', old('title'), ['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-12">
                    <label for="sub_title">Subt&iacute;tulo de la p&aacute;gina</label>
                    {!! Form::text('sub_title', old('sub_title'), ['class' => 'form-control', 'id' => 'sub_title']) !!}
                </div>
                <div class="form-group col-md-12">
                    <label for="slug"><em>Slug</em></label>
                    {!! Form::text('slug', old('slug'), ['class' => 'form-control ', 'id' => 'slug', ($page->parent) ? 'required' : '']) !!}
                </div>
                <div class="form-group col-md-4 offset-md-1">
                    <input class="form-check-input" type="checkbox" value="1" name="navigation" {{ ($page->navigation) ? 'checked' : ''  }}>
                    <label class="form-check-label" for="navigation">
                        Visible en la navegaci&oacute;n
                    </label>
                </div>
                <div class="form-group col-md-6">
                    <input class="form-check-input" type="checkbox" value="1" name="index" {{ ($page->index) ? 'checked' : ''  }}>
                    <label class="form-check-label" for="navigation">
                        Indexable
                    </label>
                </div>
                <div class="form-group col-md-10 offset-md-1">
                    <input class="form-check-input" type="checkbox" value="1" name="is_roomprices_list" {{ ($page->is_roomprices_list) ? 'checked' : ''  }}>
                    <label class="form-check-label" for="navigation">
                        Es lista de precios de habitaciones
                    </label>
                    <small class="form-text text-muted">S&oacute;lo una por sitio. Al establecer, la asignaci&oacute;n anterior ser&aacute; removida.</small>
                </div>

                <div class="form-group col-md-12">
                    <label for="formGroupExampleInput">Descripci&oacute;n</label>
                    {!! Form::textarea('description', $page->description, ['class' => 'form-control wysiwyg', 'id' => 'description']) !!}
                </div>
                <div class="form-group col-md-12">
                    <label for="excerpt"><em>Excerpt</em></label>
                    {!! Form::textarea('excerpt', old('excerpt'), ['class' => 'form-control wysiwyg', 'id' => 'excerpt']) !!}
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="row">
                <div class="form-group col-md-12">
                    <label for="layout"><em>Layout</em></label>
                    {!! Form::select('layout', $layouts, $page->layout ,['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-12">
                    <label for="layout"><em>Template</em></label>

                    {!! Form::select('template', $templates, $page->template ,['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-12">
                    <label for="form_id">Formularios</label>
                    {!! Form::select('form_id', collect([null => ''])->union($forms->pluck('name', 'id')), $page->form, ['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-12">
                    <label for="status"><em>Status</em></label>
                    {!! Form::select('status', ['hidden' => 'hidden', 'review' => 'review', 'published' => 'published'], old('status'), ['class' => 'form-control']) !!}
                </div>
                <div class="form-group col-md-12">
                    <label for="name"><em>Permalink</em></label>
                    {!! Form::text('perman_link', old('perman_link'), ['class' => 'form-control', 'readonly']) !!}
                </div>
            </div>
        </div>
    </div>
    @can('update', $page)
    <div class="row">
        <div class="col-md-12 text-left">
            <a href="javascript:void(0);" class="btn btn-info submit-using-ajax" data-on-action-success-message="Página guardada">Guardar</a>
            @can('viewAny', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $page->site])
            <button type="submit" class="btn btn-info">
                Guardar y cerrar
            </button>
            @endcan
        </div>
    </div>
    @endcan
    {!! Form::close() !!}

</div>
