<div class="col-md-12">
    @can('update', $page)
        <a href="{{ route('galleries.create', $page) }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Crear galer&iacute;a
        </a>
    @endcan
    <div class="box box-default">
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs gallery-tabs sortable-tabs" data-route="{{ route('galleries.from-page.reorder', $page) }}">
                @foreach($page->galleries->sortBy('priority') as $gallery)
                    <li class="nav-item" data-id="{{ $gallery->id }}">
                        <a href="#{{ str_slug($gallery->name)."-{$gallery->id}" }}" data-toggle="tab" aria-expanded="true" class="nav-link {{ ($loop->first) ? 'active' : '' }}">
                            {{ $gallery->name }}
                            <i class="fas fa-arrows-alt-h"></i>
                        </a>
                    </li>
                @endforeach
            </ul>
            <div class="tab-content">
                @foreach($page->galleries->sortBy('priority') as $gallery)
                    <div class="tab-pane {{ ($loop->first) ? 'active' : '' }}" id="{{ str_slug($gallery->name)."-{$gallery->id}" }}">
                        <div class="text-right">
                            @can('update', $page)
                            <a href="{{ route('galleries.edit', $gallery) }}" class="btn btn-warning">Editar Galer&iacute;a</a>
                            <a href="{{ route('galleries.delete', $gallery) }}" class="btn btn-danger delete-model">
                                <i class="fas fa-trash-alt"></i>
                                Eliminar Galer&iacute;a
                            </a>
                            @endcan
                        </div>
                        <div class="gallery-items-preview" data-route="{{ route('galleries.update', $gallery->id) }}">
                            @foreach($gallery->items->sortBy('priority') as $key => $item)
                                @isset($item->mediafile->path)
                                    <div class="item" style="background-image: url({{ $item->mediafile->path }})" data-id="{{ $item->id }}"></div>
                                @endisset
                            @endforeach
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
