<div class="col-md-12">
    <div class="row">
        <div class="col-md-12">
            <div class="text-left">
                @if($page->cards->count() > 1)
                    <a href="{{ route('cards.index', $page) }}" class="btn btn-warning">
                        <i class="fas fa-bars"></i> Reordenar
                    </a>
                @endif
                @can('update', $page)
                <a href="{{ route('cards.create', [$page, $lang]) }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Crear Postal
                </a>
                @endcan
            </div>

            <br>
            <div class="box box-default">
                <ul class="list-group">
                    @foreach($page->cards->sortBy('priority') as $card)
                        <li class="list-group-item">
                            <div class="row">
                                <div class="col-10">
                                    {{ ($card->translateOrDefault('es')) ? $card->translateOrDefault('es')->title : $card->slug }}
                                </div>
                                <div class="col-2">
                                    @can('update', $page)
                                        <a href="{{ route('cards.edit', [$card, $lang]) }}" class="btn btn-primary btn-sm">
                                            Editar
                                        </a>
                                        <a href="{{ route('cards.destroy', $card) }}" class="btn btn-danger btn-sm delete-model">
                                            Eliminar
                                        </a>
                                    @endcan
                                </div>
                            </div>

                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>
</div>
