<ol class="dd-list collapse show" id="nodePage{{$page->id}}" aria-labelledby="{{$page->id}}">
  @isset($page->children)
    @foreach ($page->children as $item)
    <li class="dd-item page-child" data-id="{{$item->id}}">
        <div class="dd-handle">
            <section class="page-status">
              <i class="fas label-{{ $item->status }}"></i>
              <span><p>{{ $item->translateOrDefault('es')->name }}</p></span>
               @if(!$item->seo)
                   <span class="label "><i class="far fa-chart-bar"></i></span>
               @endif
            </section>
            <ul class="item-actions">
                @can('update', $page)
                @foreach($item->getTranslationsArray() as $lang => $translation)
                <li>
                  <a href="{{ route('pages.show', [$item, $lang]) }}" class="page-actions label-info edit">
                    @if($lang == 'es')
                      <img src="{{ asset('cms/images/lang/mexico.png') }}" alt="" class="" />
                      <i class="fas label-{{ $translation['status'] }}"></i>
                    @else
                      <img src="{{ asset('cms/images/lang/united-states-of-america.png') }}" alt="" class="" />
                      <i class="fas label-{{ $translation['status'] }}"></i>
                    @endif
                  </a>
                </li>
                @endforeach
                @endcan
                <li>
                  @can('create', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $site])
                  <a href="{{ route('pages.addNode', [$item]) }}" class="label label-primary create"> <i class="fa fa-plus"></i></a>
                  @endcan
                </li>
                <li>
                  @can('delete', $page)
                  <a href="{{ route('pages.destroy', [$item]) }}" class="label label-danger delete-model"> <i class="far fa-trash-alt"></i></a>
                  @endcan
                </li>
            </ul>
        </div>
        @include('MGCms2019::admin.pages.node', ['page'=> $item])
    </li>
    @endforeach
  @endisset
  </ol>
