@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        @switch($route = Route::currentRouteName())
            @case('pages.index')
                @php
                    $createRoute = route('pages.create', $site);
                    $updatePermaLinksRoute = route('update.permalinks', $site);
                @endphp
                {{ Breadcrumbs::render($route, $site) }}
                @break
            @default
                @php
                    $createRoute = route('pages.create-from-current');
                    $updatePermaLinksRoute = route('update.permalinks-from-current');
                @endphp
                {{ Breadcrumbs::render($route) }}
        @endswitch
    </section>
@endsection

@section('content')
    <div class="box box-default">
        <div class="box-header row">
            <div class="col-md-12">
                <h3 class="box-title">Páginas</h3>
            </div>
            <div class="col">
                <section class="status row">
                    <article class="col-md-3">
                        <strong>Estados:</strong>
                    </article>
                    <article class="col-md-3">
                        <i>Published</i>
                        <i class="fas label-published"></i>
                    </article>
                    <article class="col-md-3">
                        <i>Review</i>
                        <i class="fas label-review"></i>
                    </article>
                    <article class="col-md-3">
                        <i>Hidden</i>
                        <i class="fas label-hidden"></i>
                    </article>
                </section>
            </div>
            <div class="col text-right">
                @can('updateFromSite', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $site])
                <a href="{{ $updatePermaLinksRoute }}" class="btn btn-warning">Actualizar <i>permalinks</i></a>
                <a href="http://{{ $site->domain }}" target="_blank" class="btn btn-primary">
                    <i class="fa fa-eye"></i> Ver sitio</a>
                @endcan
                @can('create', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $site])
                <a href="{{ $createRoute }}" class="btn btn-primary">
                    <i class="fa fa-plus"></i> Agregar página</a>
                @endcan
                @can('updateFromSite', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $site])
                <button class="btn btn-info" id="reorder">
                    <i class="fa fa-bars"></i> Reordenar</button>
                @endcan
            </div>
            <div class="col-md-12">
                @include('MGCms2019::admin.partials.formErrors')

                {{-- nestable --}}
                <div class="dd model-main-tree" id="pages" data-url="{{ route('pages.tree') }}">
                    <ol class="dd-list">
                        @foreach($pages as $i => $page)
                            <li class="dd-item" data-id="{{$page->id}}">
                                <div class="dd-handle" id="{{$page->id}}">
                                    <section class="page-status"><i class="fas label-{{ $page->status }}"></i>
                                        <span><p>{{ $page->translateOrDefault('es')->name }}</p> </span>
                                        @if(!$page->seo)
                                            <span class="label"> <i class="far fa-chart-bar"></i></span>
                                        @endif
                                        @isset($page->children)
                                            <button class="btn btn-link collapsed" type="button" data-toggle="collapse" data-target="#nodePage{{$page->id}}" aria-expanded="true" aria-controls="#nodePage{{$page->id}}">
                                                <i class="fas fa-chevron-up"></i>
                                            </button>
                                        @endisset
                                    </section>
                                    <ul class="item-actions">
                                        @can('update', $page)
                                        @foreach($page->getTranslationsArray() as $lang => $translation)
                                            <li>
                                                <a href="{{ route('pages.show', [$page->id, $lang]) }}" class="page-actions label-info edit">
                                                    @if($lang == 'es')
                                                        <img src="{{ asset('cms/images/lang/mexico.png') }}" alt="" class="">
                                                       <i class="fas label-{{ $page->translate('es')->status }}"></i>
                                                    @else
                                                        <img src="{{ asset('cms/images/lang/united-states-of-america.png') }}" alt="" class="">
                                                        <i class="fas label-{{ $page->translate('en')->status }}"></i>
                                                    @endif
                                                </a>
                                            </li>
                                        @endforeach
                                        @endcan
                                        <li>
                                            @can('create', [AvengersMG\MGCms2019\App\Cms\Pages\Page::class, $site])
                                            <a href="{{ route('pages.addNode', [$page]) }}" class="label label-primary create"> <i class="fa fa-plus"></i></a>
                                            @endcan
                                        </li>
                                        <li>
                                            @can('delete', $page)
                                            <a href="{{ route('pages.destroy', [$page]) }}" class="label label-danger delete-model"><i class="far fa-trash-alt"></i></a>
                                            @endcan
                                        </li>
                                    </ul>
                                </div>
                                @include('MGCms2019::admin.pages.node', ['page' => $page])
                            </li>
                        @endforeach
                    </ol>
                </div>
            </div>
        </div>
    </div>
@endsection
