<div class="modal fade" id="file-detail-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title text-centerex" id="modal-file-title">Informaci&oacute;n de medio</h4>
            </div>
            <div class="modal-body">
                {!! Form::open(['method' => 'put', 'id' => 'update-sites-media']) !!}
                <input type="hidden" name="id" value="" />
                <div class="form-group">
                    <label><i>PATH</i></label>
                    <input type="text" class="form-control" name="path" value="" readonly>
                </div>
                <div class="form-group">
                    {!! Form::label('name', 'Nombre: ') !!}
                    {!! Form::text('name', '', ['class' => 'form-control title'])!!}
                </div>
                <div class="form-group">
                    {!! Form::label('title', 'Título: ') !!}
                    {!! Form::text('title', '', ['class' => 'form-control title'])!!}
                </div>
                <div class="form-group">
                    {!! Form::label('alt', 'Alt: ') !!}
                    {!! Form::text('alt', '', ['class' => 'form-control title'])!!}
                </div>
                <div class="form-group">
                    {!! Form::label('link', 'Vínculo: ') !!}
                    {!! Form::text('link', '', ['class' => 'form-control title'])!!}
                </div>
                <div class="form-group">
                    {!! Form::label('type', 'Tipo: ') !!}
                    {!! Form::select('type_id', collect([null => ''])->union($files_types->pluck('type', 'id')), '', ['class' => 'form-control']) !!}
                </div>
                <div class="form-group">
                    {!! Form::label('locale', 'Lenguaje: ') !!}
                    {!! Form::select('locale', collect(app()->make('translatable.locales')->all())->mapWithkeys(function($item){ return ["{$item}" => $item]; })->all(), app()->getLocale(), ['class' => 'form-control'])!!}
                    @can('updateFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $site])
                    <a href="" class="btn btn-danger btn-block delete-model delete-model-using-ajax mediafile-translation-delete d-none">
                        <i class="fa fa-trash"></i>Eliminar traducci&oacute;n
                    </a>
                    <small class="form-text text-muted mediafile-translation-inexistent d-none">
                        Esta traducci&oacute;n no existe. D&eacute; clic en &quot;Actualizar&quot; para guardarla.
                    </small>
                    @endcan
                </div>
                <div class="form-group">
                    {!! Form::label('file_size', 'Tamaño: ') !!}
                    {!! Form::text('file_size', '', ['class' => 'form-control', 'readonly'])!!}
                </div>
                <div class="form-group">
                    {!! Form::label('status', 'Status: ') !!}
                    {!! Form::select('status', ['0' => 'No activo', '1' => 'Activo'],'', ['class' => 'form-control'])!!}
                </div>
                <div class="form-group">
                    {!! Form::label('description', 'Descripción: ') !!}
                    {!! Form::textarea('description', '', ['class' => 'form-control'])!!}
                </div>
                <div class="modal-footer">
                    <div class="row">
                        @can('deleteFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $site])
                        <div class="col-md-6">
                            <a href="" class="btn btn-danger btn-block modal-delete-mediafile delete-model delete-model-using-ajax">Eliminar</a>
                        </div>
                        @endcan
                        @can('updateFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $site])
                        <div class="col-md-6">
                            <button type="submit" class="btn btn-block btn-primary">Actualizar</button>
                        </div>
                        @endcan
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="file-dir-modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title text-centerex" id="modal-file-title">Crear directorio</h4>
            </div>
            <div class="modal-body">
                {!! Form::open(['route' => ['mediafiles.create.dir'], 'method' => 'post']) !!}
                <div class="form-group col-md-12">
                    <input type="hidden" name="path" value="{{ $public_path }}">
                    {!! Form::label('name', 'Name: ') !!}
                    {!! Form::text('name', '', ['class' => 'form-control title'])!!}
                </div>

                <div class="modal-footer">
                    <div class="row">
                        <div class="col-md-12">
                            @can('createDirectory', AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class)
                            <button type="submit" class="btn btn-block btn-primary">Crear</button>
                            @endcan
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
