@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        @switch($route = Route::currentRouteName())
            @case('mediafiles.show.dir')
                @php $useSite = true; @endphp
                {{ Breadcrumbs::render($route, $site, $path) }}
                @break
            @case('mediafiles.show.dir-from-current')
                @php $useSite = false; @endphp
                {{ Breadcrumbs::render($route, $path) }}
                @break
            @case('mediafiles.index')
                @php $useSite = true; @endphp
                {{ Breadcrumbs::render($route, $site) }}
                @break
            @default {{-- mediafiles.index-from-current --}}
                @php $useSite = false; @endphp
                {{ Breadcrumbs::render($route) }}
        @endswitch
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-primary">
                <div class="row">
                    <div class="col-md-6">
                        <h2>Media files</h2>
                    </div>
                    <div class="col-md-6">
                        <div class="box-header with-border text-right">
                            @can('create', AvengersMG\MGCms2019\App\Cms\Mediafiles\FileType::class)
                            <a href="{{ route('filetypes.create') }}" class="btn btn-primary">Crear tipo de archivo</a>
                            @endcan
                            @can('createDirectory', AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class)
                            <a href="javascript:void(0);" class="btn btn-info" data-toggle="modal" data-target="#file-dir-modal">Crear directorio</a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="box box-body">

                {{-- DROPZONE --}}
                @include('MGCms2019::admin.mediafiles.partials.dropzone')
                @php $url = '' @endphp

                <div class="container">
                    <div class="col-md-12">
                        @if(isset($breadcrumbs))
                            <ol class="breadcrumb">
                                <li>
                                    <a href="{{ $useSite? route('mediafiles.index', $site) : route('mediafiles.index-from-current') }}">Mediafiles</a>
                                    <i class="fas fa-angle-right pr-1"></i>
                                </li>
                                @php
                                    $urlArray = [];
                                    $lastBC = count($breadcrumbs) - 1;
                                @endphp
                                @foreach($breadcrumbs as $key => $bc)
                                    @php
                                      $urlArray[] = str_slug($bc); $url = implode('/', $urlArray);
                                      $isLastBC = ($key == $lastBC);
                                    @endphp
                                    <li class="{{ ($isLastBC)? 'active' : '' }}">
                                        <a href="{{ route(($useSite? 'mediafiles.show.dir' : 'mediafiles.show.dir-from-current'), ($useSite? [$site, $url] : $url)) }}">{{ $bc }}</a>
                                        @unless($isLastBC)
                                        <i class="fas fa-angle-right pr-1"></i>
                                        @endunless
                                    </li>
                                @endforeach
                            </ol>
                        @endif
                    </div>
                    <div class="col-md-12">
                        <div class="container">
                             <div class="row justify-content-center">
                                @foreach($files['dirs'] as $key => $dir)
                                <div class="col-md-4 media-dir">
                                    @php $fullDir = (empty($path))? $dir : implode('/', [$path, $dir]); @endphp
                                    <a href="{{ route(($useSite? 'mediafiles.show.dir' : 'mediafiles.show.dir-from-current'), ($useSite? [$site, $fullDir] : $fullDir)) }}">
                                       <img src="{!!asset('/cms/svg/folder.svg')!!}" class="img-fluid" alt=""><br />
                                        {{ $dir }}</a>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 row" id="sitemedia">
                        @can('viewFromSite', [AvengersMG\MGCms2019\App\Cms\Mediafiles\Mediafile::class, $site])
                            @foreach($files['files'] as $key => $file)
                                @php
                                  $localLang = app()->getLocale();
                                  $fileLangs = $file['model']->translations->pluck('locale');
                                  $fileLang = ($fileLangs->contains($localLang))
                                      ? $localLang
                                      : $fileLangs->first();
                                @endphp
                                <div class="col-md-3">
                                    <div class="media-item media-item-{{ $file['model']->id }}" data-toggle="modal" data-target="#file-detail-modal"
                                         data-id="{{ $file['model']->id }}"
                                         data-route="{{ route('mediafiles.show', $file['model']->id) }}"
                                         data-delete="{{ route('mediafiles.destroy', $file['model']->id) }}"
                                         data-update="{{ route('mediafiles.update', $file['model']->id) }}"
                                         data-path="{{ $public_path }}"
                                         data-type="{{ ($file['model']->type) ? $file['model']->type->id : ''}}"
                                         data-lang="{{ $fileLang }}"
                                         data-lang-delete-routes='@json(
                                             collect(
                                                 app()->make('translatable.locales')->all()
                                             )->mapWithKeys(function($locale) use ($file){
                                                 return ["{$locale}" => route('mediafiles.translations.destroy', [$file['model'], $locale])];
                                             })->all(),
                                             JSON_UNESCAPED_SLASHES
                                         )'
                                        >
                                        <div class="file-image @if(!$file['model']->is_image) text-center @endif" @if($file['model']->is_image) style="background-image: url('{{ url($file['model']->path) }}')" @endif>
                                            @if(!$file['model']->is_image)
                                                <span class="fiv-viv fiv-icon-{{ $file['model']->file_extension }} fiv-size-xl"></span>
                                            @endif
                                        </div>
                                        @if($file['model']->type)
                                            <p class="file-type type-{{ $file['model']->type->type }}">{{ $file['model']->type->type }}</p>
                                        @endif
                                        <p class="file-image-languages text-center">{{ $fileLangs->implode(', ') }}</p>
                                    </div>
                                </div>
                            @endforeach
                        @endcan
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    @include('MGCms2019::admin.mediafiles.partials.modal')
@endsection
