<!doctype html>
<html lang="{{ app()->getLocale() }}">

  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <title>Gorilla CMS</title>
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <link rel="stylesheet" href="{{ asset('cms/css/app.css') }}" />

    {{-- Íconos --}}
    <link rel="apple-touch-icon-precomposed" sizes="57x57" href="{{ asset('cms/favicon/apple-touch-icon-57x57.png') }}" />
    <link rel="apple-touch-icon-precomposed" sizes="114x114" href="{{ asset('cms/favicon/apple-touch-icon-114x114.png') }}" />
    <link rel="apple-touch-icon-precomposed" sizes="72x72" href="{{ asset('cms/favicon/apple-touch-icon-72x72.png') }}" />
    <link rel="apple-touch-icon-precomposed" sizes="144x144" href="{{ asset('cms/favicon/apple-touch-icon-144x144.png') }}" />
    <link rel="apple-touch-icon-precomposed" sizes="60x60" href="{{ asset('cms/favicon/apple-touch-icon-60x60.png') }}" />
    <link rel="apple-touch-icon-precomposed" sizes="120x120" href="{{ asset('cms/favicon/apple-touch-icon-120x120.png') }}" />
    <link rel="apple-touch-icon-precomposed" sizes="76x76" href="{{ asset('cms/favicon/apple-touch-icon-76x76.png') }}" />
    <link rel="apple-touch-icon-precomposed" sizes="152x152" href="{{ asset('cms/favicon/apple-touch-icon-152x152.png') }}" />
    <link rel="icon" type="image/png" href="{{ asset('cms/favicon/favicon-96x96.png" sizes="96x96') }}" />
    <link rel="icon" type="image/png" href="{{ asset('cms/favicon/favicon.ico') }}" />
  </head>

  <body class="hold-transition skin-blue sidebar-mini">
    <div id="ajax-load">
      <img src="{{ asset('cms/images/ajaxload.gif') }}" alt="" />
    </div>
    <div class="wrapper">
    @include('MGCms2019::admin.partials.nav')
    @include('MGCms2019::admin.partials.sidenav')

      <div class="content-wrapper">

        @yield('breadcrumbs') {{-- Main content --}}
        <section class="content container-fluid">

          @yield('content')

        </section>

      </div>
    @include('MGCms2019::admin.partials.footer') {{-- sidebar control --}}
    @include('MGCms2019::admin.partials.sidebarControl') {{--este formulario
      sirve para aplicar el method delete a todos los elementos que contengan href y la clase .delete-model | admincustomjs
      --}} {!! Form::open(['method' => 'delete', 'route' => ['roles.destroy', 'eliminado'], 'id' => 'delete-item']) !!} {!!
      Form::close() !!}
    </div>
    <script src="{{ asset('cms/js/app.js')  }}"></script>
    <script>
      $(document).ready(function(){
        tinymce.init({
          selector: '.wysiwyg',
          plugins: [
              'advlist autolink lists link image charmap print preview anchor',
              'searchreplace visualblocks code fullscreen',
              'insertdatetime media table paste code help wordcount '
          ],
          toolbar: "undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | table | fontsizeselect",
          skin_url: '{{ asset('cms/css/tinymce/skins/ui/oxide') }}',
          content_css: '{{ asset('cms/css/tinymce/skins/content/default/content.css') }}',
          valid_elements : '*[*]',
          {{-- Si el sitio ya está establecido, hacer las URL absolutas --}}
          @php
            $is_page_set = isset($page);
          @endphp
          @if($is_page_set || isset($site))
          relative_urls : false,
          remove_script_host : false,
          document_base_url : "{{ ($is_page_set)? $page->site->base_url : $site->base_url }}",
          @endif
        });

        $('#reorder').on('click', function () {
          var mainNestable = $('.dd.model-main-tree');

          if ($(this).hasClass('active')) {
            let serialized = mainNestable.nestable('serialize');

            $.ajax({
              type: 'PUT',
              url: mainNestable.data('url'),
              data: JSON.stringify(serialized),
              contentType: 'json',
              headers: {
                'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
              }
            }).done(function(){
              window.location.reload();
            });
          } else {
            $(this).addClass('active btn-warning').text('').append('<i class="fa fa-close"></i> Finalizar');
            $('.dd-list li div').css('cursor', 'move');
            mainNestable.nestable();
          }
        });

        $('#reorderOne').on('click', function () {
          var mainNestable = $('.dd.model-main-tree');

          if ($(this).hasClass('active')) {
            let serialized = mainNestable.nestable('serialize');

            $.ajax({
              type: 'PUT',
              url: mainNestable.data('url'),
              data: JSON.stringify(serialized),
              contentType: 'json',
              headers: {
                'X-CSRF-Token': $('meta[name="csrf-token"]').attr('content')
              }
            }).done(function(){
              window.location.reload();
            });
          } else {
            $(this).addClass('active btn-warning').text('').append('<i class="fa fa-close"></i> Finalizar');
            $('.dd-list li div').css('cursor', 'move');
            mainNestable.nestable({
              maxDepth:4
            });
          }
        });

        $('.dropdown-toggle').dropdown();
      });
    </script>
    @stack('scripts')
  </body>
</html>
