
@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <div class="col-md-12 text-right">
                        @can('create', AvengersMG\MGCms2019\App\Cms\Forms\Form::class)
                        <a href="{{ route('forms.create') }}" class="btn btn-primary">Agregar form</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body">
                  @include('MGCms2019::admin.partials.formErrors')
                  <div class="col-md-12">
                    <table class="table table-bordered table-striped generalTable username-table">
                        <thead>
                        <tr>
                            <th>#ID</th>
                            <th>Nombre</th>
                            <th>Manejador</th>
                            <th>Recipientes</th>
                            <th>Fecha de creaci&oacute;n</th>
                            <th>Acciones</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($forms as $form)
                            <tr>
                                <td>{{ $form->id }}</td>
                                <td>{{ $form->name }}</td>
                                <td>{{ $form->handler }}</td>
                                <td>
                                    {{-- @dd($form->recipients) --}}
                                        @foreach($form->recipients[0] as $recipient)
                                            <span class="badge bg-blue">{{ $recipient['email'] }}</span>
                                        @endforeach
                                        @foreach($form->recipients[1] as $recipient)
                                            <span class="badge bg-red">{{ $recipient['email'] }}</span>
                                        @endforeach
                                </td>
                                <td>{{ $form->created_at }}</td>
                                <td class="text-center">
                                    @can('update', $form)
                                    <a href="{{ route('forms.edit', $form) }}" class="btn btn-success btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Editar"><i class="fa fa-edit"></i></a>
                                    @endcan
                                    @can('delete', $form)
                                    <a href="{{ route('forms.destroy', $form) }}" class="btn btn-danger btn-xs tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Eliminar"><i class="far fa-trash-alt"></i></a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                        <tfoot>
                        <tr>
                            <th>#ID</th>
                            <th>Nombre</th>
                            <th>Manejador</th>
                            <th>Recipientes</th>
                            <th>Fecha de creaci&oacute;n</th>
                            <th>Acciones</th>
                        </tr>
                        </tfoot>
                    </table>
                  </div>
                </div>
            </div>
        </div>
    </div>
@endsection
