@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $form) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <h3>Editar {{ $form->name }}</h3>
                </div>

                <div class="box-body">
                    @include('MGCms2019::admin.partials.formErrors')
                    {!! Form::model($form, [ 'route' => ['forms.update', $form->id], 'method' => 'put' ]) !!}
                    <div class="form-group col-md-6">
                        <label>Nombre:</label>
                        {!! Form::text('name', $form->name, ['class' => 'form-control', 'required']) !!}
                    </div>
                    <div class="form-group col-md-6">
                        <label>Manejador:</label>
                        {!! Form::select('handler', $mails, $form->handler, ['class' => 'form-control', 'required']) !!}
                    </div>
                    <div class="form-group col-md-6">
                    <div class="custom-control custom-switch">
                        {!! Form::checkbox('debug', 1, ($form->debug) ? true : false, ['id' => 'permanentpromo', 'class' => 'custom-control-input']) !!}
                        <label class="custom-control-label" for="permanentpromo">Modo de prueba</label>
                        </div>
                    </div>
                    <div class="form-group col-md-12 text-right">
                        <button type="button" class="btn btn-info" id="add-recipient">+ A&ntilde;adir recipientes</button>
                    </div>
                    <div class="form-group col-md-12">
                        <label>Recipientes:</label>
                    </div>

                    <div class="form-group col-md-12">
                        <div class="row recipients">
                            @foreach($form->recipients[0] as $key => $recipient)
                                <div class="form-group col-md-6">
                                    <label>Correo electr&oacute;nico:</label>
                                    {!! Form::email('email[]', $recipient['email'], ['class' => 'form-control']) !!}
                                </div>

                                <div class="form-group col-md-6">
                                    <label>Nombre del recipiente:</label>
                                    {!! Form::text('user[]', $recipient['name'], ['class' => 'form-control']) !!}
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="form-group col-md-12">
                        <label>Recipientes Copia Oculta:</label>
                    </div>
                    <div class="form-group col-md-12 text-right">
                        <button type="button" class="btn btn-info" id="add-recipient-bcc">+ A&ntilde;adir recipientes Bcc</button>
                    </div>
                    <div class="form-group col-md-12">
                        <div class="row recipients-bcc">
                            @foreach($form->recipients[1] as $key => $recipient)
                                <div class="form-group col-md-6">
                                    <label>Correo electr&oacute;nico:</label>
                                    {!! Form::email('email_bcc[]', $recipient['email'], ['class' => 'form-control']) !!}
                                </div>

                                <div class="form-group col-md-6">
                                    <label>Nombre del recipiente:</label>
                                    {!! Form::text('user_bcc[]', $recipient['name'], ['class' => 'form-control']) !!}
                                </div>
                            @endforeach
                        </div>
                    </div>

                    @can('update', $form)
                    <div class="form-group col-md-12 text-right">
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </div>
                    @endcan
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
@endsection
