@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <h3>Crear Formulario</h3>
                </div>

                <div class="box-body">
                    @include('MGCms2019::admin.partials.formErrors')
                    {!! Form::open([ 'route' => 'forms.store', 'method' => 'post' ]) !!}
                    <div class="form-group col-md-6">
                        <label>Nombre:</label>
                        {!! Form::text('name', old('name'), ['class' => 'form-control', 'required']) !!}
                    </div>
                    <div class="form-group col-md-6">
                        <label>Manejador:</label>
                        {!! Form::select('handler', $mails, '', ['class' => 'form-control', 'required']) !!}
                    </div>
                    <div class="form-group col-md-6">
                        <div class="custom-control custom-switch">
                        {!! Form::checkbox('debug', 1, false, ['id' => 'permanentpromo' ,'class' => 'custom-control-input']) !!}
                        <label class="custom-control-label" for="permanentpromo">Modo de prueba</label>
                        </div>
                    </div>
                    <div class="form-group col-md-12 text-right">
                        <button type="button" class="btn btn-info" id="add-recipient">+ A&ntilde;adir recipientes</button>
                    </div>
                    <div class="form-group col-md-12">
                        <div class="row recipients">
                            <div class="form-group col-md-6">
                                <label>Correo electr&oacute;nico:</label>
                                {!! Form::email('email[]', '', ['class' => 'form-control']) !!}
                            </div>

                            <div class="form-group col-md-6">
                                <label>Nombre del recipiente:</label>
                                {!! Form::text('user[]', '', ['class' => 'form-control']) !!}
                            </div>
                        </div>
                        <div class="row">
                            <h4>Con copia oculta</h4>
                        </div>
                        <div class="form-group col-md-12 text-right">
                            <button type="button" class="btn btn-info" id="add-recipient-bcc">+ A&ntilde;adir recipientes Bcc</button>
                        </div>
                        <div class="row recipients-bcc">
                            <div class="form-group col-md-6">
                                <label>email:</label>
                                {!! Form::email('email_bcc[]', '', ['class' => 'form-control']) !!}
                            </div>

                            <div class="form-group col-md-6">
                                <label>nombre:</label>
                                {!! Form::text('user_bcc[]', '', ['class' => 'form-control']) !!}
                            </div>
                        </div>
                    </div>
                    @can('create', AvengersMG\MGCms2019\App\Cms\Forms\Form::class)
                    <div class="form-group col-md-12">
                        <button type="submit" class="btn btn-primary">Crear</button>
                    </div>
                    @endcan
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
@endsection
