@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <div class="col-md-12 text-right">
                        <a href="{{ route('filetypes.create') }}" class="btn btn-primary">Agregar Tipo de Archivo</a>
                    </div>
                </div>

                <div class="box-body" id="usser-tables">
                  @include('MGCms2019::admin.partials.formErrors')
                  <div class="col-md-12">
                    <table class="table table-bordered table-striped generalTable">
                        <thead>
                        <tr>
                            <th>#ID</th>
                            <th>Tipo</th>
                            <th>Acciones</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($filetypes as $filetype)
                            <tr>
                                <td>{{ $filetype->id }}</td>
                                <td>{{ $filetype->type }}</td>
                                <td class="text-center">
                                    <a href="{{ route('filetypes.edit', $filetype) }}" class="btn btn-success btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Editar"><i class="fa fa-edit"></i></a>
                                    <a href="{{ route('filetypes.destroy', $filetype) }}" class="btn btn-danger btn-xs tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Eliminar"><i class="far fa-trash-alt"></i></a>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                  </div>
                </div>
            </div>
        </div>
    </div>
@endsection
