@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $page, $lang) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default bgwpm">
                <div class="box-header with-border">
                    <h3>Crear Tour</h3>
                </div>
                <div class="box-body">
                    <div class="container">
                        @include('MGCms2019::admin.partials.formErrors')
                        {!! Form::open(['route' => 'tours.store', 'methods' => 'post', 'files' => true]) !!}
                        {!! Form::hidden('page_id', $page->id) !!}
                        {!! Form::hidden('locale', $lang) !!}
                        <div class="row">
                            <div class="form-group col-md-12">
                                <label for="">Nombre</label>
                                {!! Form::text('name', $page->title ,['class' => 'form-control', 'readonly']) !!}
                            </div>
                            <div class="form-group col-md-6">
                                <label for="">Actividad</label>
                                {!! Form::text('activity', '' ,['class' => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-6">
                                <label for="">Recomendaciones</label>
                                {!! Form::text('recommendations', '' ,['class' => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-6">
                                <label for="">Restricci&oacute;n</label>
                                {!! Form::text('restriction', '' ,['class' => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-6">
                                <label for="">Duraci&oacute;n</label>
                                {!! Form::text('duration', '' ,['class' => 'form-control']) !!}
                            </div>
                            {{--<div class="form-group col-md-12">--}}
                                {{--<label for="">Descripci&oacute;n corta</label>--}}
                                {{--{!! Form::textarea('short_description', '' ,['class' => 'form-control wysiwyg']) !!}--}}
                            {{--</div>--}}
                            @can('update', $page)
                            <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-info">Guardar</button>
                            </div>
                            @endcan
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
