@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $page, $lang) }}
    </section>
@endsection

@section('content')
    <div class="container add-special">
        <div class="row">
            <div class="col-md-12">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3>Crear Oferta</h3>
                    </div>
                    <div class="box-body">
                        @include('MGCms2019::admin.partials.formErrors')
                        {!! Form::open(['route' => 'specials.store', 'methods' => 'post', 'files' => true]) !!}
                        {!! Form::hidden('page_id', $page->id) !!}
                        {!! Form::hidden('locale', $lang) !!}
                        <div class="row">
                            <div class="form-group col-md-4">
                                <label for="">Nombre de Oferta</label>
                                {!! Form::text('name', $page->name ,['class' => 'form-control', 'readonly']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label for="">Ventana de reservaci&oacute;n</label>
                                {!! Form::text('booking_w', '' ,['class' => 'form-control date-picker']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label for="">Ventana de viaje</label>
                                {!! Form::text('travel_w', '' ,['class' => 'form-control date-picker']) !!}
                            </div>
                             <div class="form-group col-md-4">
                                <div class="custom-control custom-switch">
                                   {!! Form::checkbox('countdown', 1, false, ['id' => 'counterpromo','class' => 'custom-control-input']) !!}
                                  <label class="custom-control-label" for="counterpromo">Cuenta regresiva</label>
                                </div>
                            </div>
                            <div class="form-group col-md-4">
                                 <div class="custom-control custom-switch">
                                  {!! Form::checkbox('permanent', 0, false, ['id' => 'permanentpromo' ,'class' => 'custom-control-input']) !!}
                                  <label class="custom-control-label" for="permanentpromo">Promoci&oacute;n permanente</label>
                                </div>
                            </div>
                            <div class='form-group col-sm-4'>
                                <label for="">Fecha y hora para notificaciones</label>
                                {!! Form::text('notification_time', old('notification_time'), ['class' => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-12">
                                <div class="row callnumber">
                                    <div class="form-group col-md-3">
                                        {!! Form::checkbox('bookingcta', 1, null, ['class' => 'bookingcta']) !!}
                                        <label class="" for="bookingcta">Booking</label>
                                    </div>
                                    <div class="form-group col-md-3">
                                        {!! Form::checkbox('llamadacta', 1, null, ['class' => 'llamadacta']) !!}
                                        <label class="" for="llamadacta">Llamada</label>
                                    </div>
                                    <div class="form-group col-md-6">
                                        {!! Form::checkbox('linkcta', 1, null, ['class' => 'linkcta']) !!}
                                        <label class="" for="linkcta">Custom</label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-12">
                                <label for="">T&eacute;rminos y condiciones</label>
                                {!! Form::textarea('terms', old('terms'), ['class' => 'form-control wysiwyg']) !!}
                            </div>
                        </div>
                        @can('update', $page)
                        <div class="box-footer text-right">
                            <button type="submit" class="btn btn-info">Crear</button>
                        </div>
                        @endcan
                        {!! Form::close() !!}
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection
