@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection
@section('content')

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-header">
                    <div class="col-md-12 text-right">
                        @can('create', AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Service::class)
                        <a href="{{ route('services.create') }}" class="btn btn-primary">Agregar Servicio</a>
                        @endcan
                    </div>
                </div>

                <div class="box-body" id="usser-tables">
                  @include('MGCms2019::admin.partials.formErrors')
                  <div class="col-md-12">
                    <table class="table table-bordered table-striped generalTable username-table">
                        <thead>
                        <tr>
                            <th>#ID</th>
                            <th>Name</th>
                            <th>Name ES</th>
                            <th>Icon</th>
                            <th>Image</th>
                            <th>Created at</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($services as $service)
                            <tr>
                                <td>{{ $service->id }}</td>
                                <td>{{ $service->name }}</td>
                                <td>{{ $service->name_es }}</td>
                                <td>{{ $service->icon }}</td>
                                <td class="text-center">
                                    <img src="{{ asset($service->image) }}" alt="">
                                </td>
                                <td>{{ $service->created_at }}</td>
                                <td>
                                    @can('update', $service)
                                    <a href="{{ route('services.edit', $service) }}" class="btn btn-success btn-xs tooltip-item" data-toggle="tooltip" data-placement="top" title="Editar"><i class="fa fa-edit"></i></a>
                                    @endcan
                                    @can('delete', $service)
                                    <a href="{{ route('services.destroy', $service) }}" class="btn btn-danger btn-xs tooltip-item delete-model" data-toggle="tooltip" data-placement="top" title="Eliminar"><i class="far fa-trash-alt"></i></a>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>#ID</th>
                                <th>Name</th>
                                <th>Name ES</th>
                                <th>Icon</th>
                                <th>Image</th>
                                <th>Created at</th>
                                <th>Actions</th>
                            </tr>
                        </tfoot>
                    </table>
                  </div>
                </div>
            </div>
        </div>
    </div>

@endsection
