@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName()) }}
    </section>
@endsection

@section('content')

<div class="row">
    <div class="col-md-12">
        <div class="box box-default">
            <div class="box-header with-border">
                <h3>Crear Servicio</h3>
                <div class="col-md-12 text-right">
                    @can('viewAny', AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Service::class)
                    <a href="{{ route('services.index') }}" class="btn btn-primary">Regresar a Servicios</a>
                    @endcan
                </div>
            </div>

            <div class="box-body">
                @include('MGCms2019::admin.partials.formErrors')
                <div class="row">
                    {!! Form::open(['route' => 'services.store', 'methods' => 'post', 'files' => true]) !!}
                    @include('MGCms2019::admin.components.restaurants.services.form')
                    @can('create', AvengersMG\MGCms2019\App\Cms\Components\Restaurants\Service::class)
                    <div class="box-footer text-right">
                        <button type="submit" class="btn btn-info">Crear</button>
                    </div>
                    @endcan
                    {!! Form::close() !!}
                </div>
            </div>

        </div>
    </div>
</div>

@endsection
