@extends('MGCms2019::admin.layouts.admin')

@section('breadcrumbs')
    <section class="content-header">
        <h1>Gorilla CMS </h1>
        {{ Breadcrumbs::render(Route::currentRouteName(), $page, $lang) }}
    </section>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="box box-default">
                <div class="box-header with-border">
                    <h3>Crear Restaurante</h3>
                </div>
                <div class="box-body">
                    <div class="container">
                        @include('MGCms2019::admin.partials.formErrors')
                        {!! Form::open(['route' => 'restaurants.store', 'methods' => 'post', 'files' => true]) !!}
                        {!! Form::hidden('page_id', $page->id) !!}
                        {!! Form::hidden('locale', $lang) !!}
                        <div class="row">
                            <div class="form-group col-md-4">
                                <label for="">Nombre de la página:</label>
                                {!! Form::text('name', $page->title ,['class' => 'form-control', 'readonly']) !!}
                            </div>
                             <div class="form-group col-md-4">
                                <label for="">T&iacute;tulo</label>
                                {!! Form::text('title', '' ,['class' => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-4">
                                <label for="">Subt&iacute;tulo</label>
                                {!! Form::text('subtitle', '' ,['class' => 'form-control']) !!}
                            </div>
                            <div class="form-group col-md-12 text-right">
                                <button type="button" class="btn btn-warning" id="add-horarios">+ Agregar horarios</button>
                            </div>
                            <h3><span class="badge badge-pill badge-info">Servicios de restaurantes</span></h3>
                            <div class="col-md-12">
                                <div class="horarios row">
                                    <div class="form-group col-md-3">
                                        <label for="">Servicio EN</label>
                                        {!! Form::text('servicio[]', null ,['class' => 'form-control']) !!}
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="">Servicio ES</label>
                                        {!! Form::text('servicio_es[]', null ,['class' => 'form-control']) !!}
                                    </div>
                                    <div class="form-group col-md-3">
                                    <label for="">Abierto en</label>
                                        {!! Form::time('open[]', null ,['class' => 'form-control']) !!}
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label for="">Cerrado a</label>
                                        {!! Form::time('close[]', null ,['class' => 'form-control']) !!}
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-12">
                                <h5>Servicios:</h5>
                                <ul class="amenities-list col-md-12">
                                    @foreach ($services as $service)
                                    <li>
                                        <label for="">
                                            {!! Form::checkbox('services[]', $service->id) !!} 
                                            {{ $service->name }}
                                        </label>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                            <div class="form-group col-md-12" id="menus">
                                <label for="">Men&uacute;s</label><br />
                                <div class="form-group col-md-12 text-right">
                                    <button type="button" class="btn btn-warning btn-xs" id="add-menus"><i class="fa fa-plus"></i> Agregar menú</button><br /><br />
                                </div>
                                <div class="custom-file">
                                  {!! Form::file('menus[]', [ 'class' => 'custom-file-input']) !!}
                                  <label class="custom-file-label">Selecciona Menú</label>
                                </div>
                                 <br /><br />
                            </div>
                            <div class="form-group col-md-12">
                                <label for="">Contenido</label> {!! Form::textarea('body', old('body'),['class' => 'form-control wysiwyg']) !!}
                            </div>
                             
                            
                            @can('update', $page)
                            <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-info">Guardar</button>
                            </div>
                            @endcan
                        </div>
                        {!! Form::close() !!}
                   </div>
                </div>

            </div>
        </div>
    </div>
@endsection
